/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InputFile {
    @Nonnull
    final String filePath;
    @Nonnull
    private final File sourceFile;
    @Nonnull
    private final BufferedReader input;

    @Nullable
    public static InputFile createIfFileExists(@Nonnull List<File> sourceDirs, @Nonnull String filePath) throws IOException {
        File sourceFile = InputFile.findSourceFile(sourceDirs, filePath);
        return sourceFile == null ? null : new InputFile(filePath, sourceFile);
    }

    @Nullable
    private static File findSourceFile(@Nonnull List<File> sourceDirs, @Nonnull String filePath) {
        int p = filePath.indexOf(47);
        String topLevelPackage = p < 0 ? "" : filePath.substring(0, p);
        int n = sourceDirs.size();
        for (int i = 0; i < n; ++i) {
            File sourceDir = sourceDirs.get(i);
            File sourceFile = InputFile.getSourceFile(sourceDir, topLevelPackage, filePath);
            if (sourceFile == null) continue;
            InputFile.giveCurrentSourceDirHighestPriority(sourceDirs, i);
            InputFile.addRootSourceDirIfNew(sourceDirs, filePath, sourceFile);
            return sourceFile;
        }
        return null;
    }

    @Nullable
    private static File getSourceFile(@Nonnull File sourceDir, @Nonnull String topLevelPackage, @Nonnull String filePath) {
        File file = new File(sourceDir, filePath);
        if (file.exists()) {
            return file;
        }
        File[] subDirs = sourceDir.listFiles(subDir -> subDir.isDirectory() && !subDir.isHidden() && !subDir.getName().equals(topLevelPackage));
        if (subDirs != null && subDirs.length > 0) {
            for (File subDir2 : subDirs) {
                File sourceFile = InputFile.getSourceFile(subDir2, topLevelPackage, filePath);
                if (sourceFile == null) continue;
                return sourceFile;
            }
        }
        return null;
    }

    private static void giveCurrentSourceDirHighestPriority(@Nonnull List<File> sourceDirs, @Nonnegative int currentSourceDirIndex) {
        if (currentSourceDirIndex > 0) {
            File firstSourceDir = sourceDirs.get(0);
            File currentSourceDir = sourceDirs.get(currentSourceDirIndex);
            if (!firstSourceDir.getPath().startsWith(currentSourceDir.getPath())) {
                sourceDirs.set(currentSourceDirIndex, firstSourceDir);
                sourceDirs.set(0, currentSourceDir);
            }
        }
    }

    private static void addRootSourceDirIfNew(@Nonnull List<File> sourceDirs, @Nonnull String filePath, @Nonnull File sourceFile) {
        String sourceFilePath = sourceFile.getPath();
        String sourceRootDir = sourceFilePath.substring(0, sourceFilePath.length() - filePath.length());
        File newSourceDir = new File(sourceRootDir);
        if (!sourceDirs.contains(newSourceDir)) {
            sourceDirs.add(0, newSourceDir);
        }
    }

    private InputFile(@Nonnull String filePath, @Nonnull File sourceFile) throws IOException {
        this.filePath = filePath;
        this.sourceFile = sourceFile;
        this.input = new BufferedReader(new FileReader(sourceFile, StandardCharsets.UTF_8));
    }

    @Nonnull
    String getSourceFileName() {
        return this.sourceFile.getName();
    }

    @Nonnull
    String getSourceFilePath() {
        String path = this.sourceFile.getPath();
        return path.startsWith("..") ? path.substring(3) : path;
    }

    @Nullable
    String nextLine() throws IOException {
        return this.input.readLine();
    }

    void close() throws IOException {
        this.input.close();
    }
}

