/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit5;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Capturing;
import mockit.Injectable;
import mockit.Mocked;
import mockit.Tested;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class JMockitExtension
extends TestRunnerDecorator
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestExecutionExceptionHandler {
    @Nullable
    private SavePoint savePointForTestClass;
    @Nullable
    private SavePoint savePointForTest;
    @Nullable
    private SavePoint savePointForTestMethod;
    @Nullable
    private Throwable thrownByTest;
    private Object[] parameterValues;
    private ParamValueInitContext initContext = new ParamValueInitContext(null, null, null, "No callbacks have been processed, preventing parameter population");

    public void beforeAll(@Nonnull ExtensionContext context) {
        if (JMockitExtension.isRegularTestClass(context)) {
            Class testClass = context.getTestClass().orElse(null);
            this.savePointForTestClass = new SavePoint();
            TestRun.setCurrentTestClass(testClass);
            if (testClass == null) {
                this.initContext = new ParamValueInitContext(null, null, null, "@BeforeAll setup failed to acquire 'Class' of test");
                return;
            }
            Object testInstance = context.getTestInstance().orElse(null);
            Method beforeAllMethod = Utilities.getAnnotatedDeclaredMethod(testClass, BeforeAll.class);
            if (testInstance == null) {
                this.initContext = new ParamValueInitContext(null, testClass, beforeAllMethod, "@BeforeAll setup failed to acquire instance of test class");
                return;
            }
            if (beforeAllMethod != null) {
                this.initContext = new ParamValueInitContext(testInstance, testClass, beforeAllMethod, null);
                this.parameterValues = JMockitExtension.createInstancesForAnnotatedParameters(testInstance, beforeAllMethod, null);
            }
        }
    }

    private static boolean isRegularTestClass(@Nonnull ExtensionContext context) {
        Class testClass = context.getTestClass().orElse(null);
        return testClass != null && !testClass.isAnnotationPresent(Nested.class);
    }

    public void postProcessTestInstance(@Nonnull Object testInstance, @Nonnull ExtensionContext context) {
        if (JMockitExtension.isRegularTestClass(context)) {
            TestRun.enterNoMockingZone();
            try {
                JMockitExtension.handleMockFieldsForWholeTestClass(testInstance);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
            TestRun.setRunningIndividualTest(testInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeEach(@Nonnull ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        Class testClass = context.getTestClass().orElse(null);
        if (testInstance == null) {
            this.initContext = new ParamValueInitContext(null, null, null, "@BeforeEach setup failed to acquire instance of test class");
            return;
        }
        TestRun.prepareForNextTest();
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTest = new SavePoint();
            JMockitExtension.createInstancesForTestedFieldsBeforeSetup(testInstance);
            if (testClass == null) {
                this.initContext = new ParamValueInitContext(null, null, null, "@BeforeEach setup failed to acquire Class<?> of test");
                return;
            }
            Method beforeEachMethod = Utilities.getAnnotatedDeclaredMethod(testClass, BeforeEach.class);
            if (beforeEachMethod != null) {
                this.initContext = new ParamValueInitContext(testInstance, testClass, beforeEachMethod, null);
                this.parameterValues = JMockitExtension.createInstancesForAnnotatedParameters(testInstance, beforeEachMethod, null);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(@Nonnull ExtensionContext context) {
        Class testClass = context.getTestClass().orElse(null);
        Method testMethod = context.getTestMethod().orElse(null);
        Object testInstance = context.getTestInstance().orElse(null);
        if (testMethod == null || testInstance == null) {
            this.initContext = new ParamValueInitContext(testInstance, testClass, testMethod, "@Test failed to acquire instance of test class, or target method");
            return;
        }
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTestMethod = new SavePoint();
            JMockitExtension.createInstancesForTestedFieldsFromBaseClasses(testInstance);
            this.initContext = new ParamValueInitContext(testInstance, testClass, testMethod, null);
            this.parameterValues = JMockitExtension.createInstancesForAnnotatedParameters(testInstance, testMethod, null);
            JMockitExtension.createInstancesForTestedFields(testInstance);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        TestRun.setRunningIndividualTest(testInstance);
    }

    public boolean supportsParameter(@Nonnull ParameterContext parameterContext, @Nonnull ExtensionContext extensionContext) {
        return parameterContext.isAnnotated(Tested.class) || parameterContext.isAnnotated(Mocked.class) || parameterContext.isAnnotated(Injectable.class) || parameterContext.isAnnotated(Capturing.class);
    }

    public Object resolveParameter(@Nonnull ParameterContext parameterContext, @Nonnull ExtensionContext extensionContext) {
        int parameterIndex = parameterContext.getIndex();
        if (this.parameterValues == null) {
            String warning = this.initContext.warning;
            StringBuilder exceptionMessage = new StringBuilder("JMockit failed to provide parameters to JUnit 5 ParameterResolver.");
            if (warning != null) {
                exceptionMessage.append("\nAdditional info: ").append(warning);
            }
            exceptionMessage.append("\n - Class: ").append(this.initContext.displayClass());
            exceptionMessage.append("\n - Method: ").append(this.initContext.displayMethod());
            throw new IllegalStateException(exceptionMessage.toString());
        }
        return this.parameterValues[parameterIndex];
    }

    public void handleTestExecutionException(@Nonnull ExtensionContext context, @Nonnull Throwable throwable) throws Throwable {
        this.thrownByTest = throwable;
        throw throwable;
    }

    public void afterTestExecution(@Nonnull ExtensionContext context) {
        if (this.savePointForTestMethod != null) {
            TestRun.enterNoMockingZone();
            try {
                this.savePointForTestMethod.rollback();
                this.savePointForTestMethod = null;
                if (this.thrownByTest != null) {
                    StackTrace.filterStackTrace(this.thrownByTest);
                }
                Error expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
                JMockitExtension.clearTestedObjectsIfAny();
                if (expectationsFailure != null) {
                    StackTrace.filterStackTrace(expectationsFailure);
                    throw expectationsFailure;
                }
            }
            finally {
                TestRun.finishCurrentTestExecution();
                TestRun.exitNoMockingZone();
            }
        }
    }

    public void afterEach(@Nonnull ExtensionContext context) {
        if (this.savePointForTest != null) {
            this.savePointForTest.rollback();
            this.savePointForTest = null;
        }
    }

    public void afterAll(@Nonnull ExtensionContext context) {
        if (this.savePointForTestClass != null && JMockitExtension.isRegularTestClass(context)) {
            this.savePointForTestClass.rollback();
            this.savePointForTestClass = null;
            JMockitExtension.clearFieldTypeRedefinitions();
            TestRun.setCurrentTestClass(null);
        }
    }

    private static class ParamValueInitContext {
        private final Object instance;
        private final Class<?> clazz;
        private final Method method;
        private final String warning;

        ParamValueInitContext(Object instance, Class<?> clazz, Method method, String warning) {
            this.instance = instance;
            this.clazz = clazz;
            this.method = method;
            this.warning = warning;
        }

        boolean isBeforeAllMethod() {
            return this.method.getDeclaredAnnotation(BeforeAll.class) != null;
        }

        boolean isBeforeEachMethod() {
            return this.method.getDeclaredAnnotation(BeforeEach.class) != null;
        }

        String displayClass() {
            if (this.clazz == null) {
                return "<no class reference>";
            }
            return this.clazz.getName();
        }

        String displayMethod() {
            if (this.method == null) {
                return "<no method reference>";
            }
            String methodPrefix = this.isBeforeAllMethod() ? "@BeforeAll " : (this.isBeforeEachMethod() ? "@BeforeEach " : "");
            String args = Arrays.stream(this.method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", "));
            return methodPrefix + this.method.getName() + "(" + args + ")";
        }

        public String toString() {
            return "ParamContext{hasInstance=" + (this.instance == null ? "false" : "true") + ", class=" + this.clazz + ", method=" + this.method + "}";
        }
    }
}

