/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.metadata.ClassMetadataReader;
import mockit.asm.types.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.ClassIdentification;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.capturing.CapturedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;

public final class CaptureTransformer<M>
implements ClassFileTransformer {
    @Nonnull
    private final CapturedType capturedType;
    @Nonnull
    private final String capturedTypeDesc;
    @Nonnull
    private final CaptureOfImplementations<M> captureOfImplementations;
    @Nonnull
    private final Map<ClassIdentification, byte[]> transformedClasses;
    @Nonnull
    private final Map<String, Boolean> superTypesSearched;
    @Nullable
    private final M typeMetadata;
    private boolean inactive;

    CaptureTransformer(@Nonnull CapturedType capturedType, @Nonnull CaptureOfImplementations<M> captureOfImplementations, boolean registerTransformedClasses, @Nullable M typeMetadata) {
        this.capturedType = capturedType;
        this.capturedTypeDesc = JavaType.getInternalName(capturedType.baseType);
        this.captureOfImplementations = captureOfImplementations;
        this.transformedClasses = registerTransformedClasses ? new HashMap(2) : Collections.emptyMap();
        this.superTypesSearched = new HashMap<String, Boolean>();
        this.typeMetadata = typeMetadata;
    }

    public void deactivate() {
        this.inactive = true;
        if (!this.transformedClasses.isEmpty()) {
            for (Map.Entry<ClassIdentification, byte[]> classNameAndOriginalBytecode : this.transformedClasses.entrySet()) {
                ClassIdentification classId = classNameAndOriginalBytecode.getKey();
                byte[] originalBytecode = classNameAndOriginalBytecode.getValue();
                Startup.redefineMethods(classId, originalBytecode);
            }
            this.transformedClasses.clear();
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String classDesc, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        if (classBeingRedefined != null || this.inactive || CapturedType.isNotToBeCaptured(protectionDomain, classDesc)) {
            return null;
        }
        if (this.isClassToBeCaptured(loader, classfileBuffer)) {
            String className = classDesc.replace('/', '.');
            ClassReader cr = new ClassReader(classfileBuffer);
            return this.modifyAndRegisterClass(loader, className, cr);
        }
        return null;
    }

    private boolean isClassToBeCaptured(@Nullable ClassLoader loader, @Nonnull byte[] classfileBuffer) {
        ClassMetadataReader cmr = new ClassMetadataReader(classfileBuffer);
        String superName = cmr.getSuperClass();
        if (this.capturedTypeDesc.equals(superName)) {
            return true;
        }
        String[] interfaces = cmr.getInterfaces();
        if (interfaces != null && this.isClassWhichImplementsACapturingInterface(interfaces)) {
            return true;
        }
        return superName != null && this.searchSuperTypes(loader, superName, interfaces);
    }

    private boolean isClassWhichImplementsACapturingInterface(@Nonnull String[] interfaces) {
        for (String implementedInterface : interfaces) {
            if (!this.capturedTypeDesc.equals(implementedInterface)) continue;
            return true;
        }
        return false;
    }

    private boolean searchSuperTypes(@Nullable ClassLoader loader, @Nonnull String superName, @Nullable String[] interfaces) {
        if (!"java/lang/Object".equals(superName) && !superName.startsWith("mockit/") && this.searchSuperType(loader, superName)) {
            return true;
        }
        if (interfaces != null && interfaces.length > 0) {
            for (String itf : interfaces) {
                if (itf.startsWith("java/") || itf.startsWith("javax/") || !this.searchSuperType(loader, itf)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchSuperType(@Nullable ClassLoader loader, @Nonnull String superName) {
        Boolean extendsCapturedType = this.superTypesSearched.get(superName);
        if (extendsCapturedType == null) {
            byte[] classfileBytes = ClassFile.getClassFile(loader, superName);
            extendsCapturedType = this.isClassToBeCaptured(loader, classfileBytes);
            this.superTypesSearched.put(superName, extendsCapturedType);
        }
        return extendsCapturedType;
    }

    @Nonnull
    private byte[] modifyAndRegisterClass(@Nullable ClassLoader loader, @Nonnull String className, @Nonnull ClassReader cr) {
        BaseClassModifier modifier = this.captureOfImplementations.createModifier(loader, cr, this.capturedType.baseType, this.typeMetadata);
        cr.accept(modifier);
        ClassIdentification classId = new ClassIdentification(loader, className);
        byte[] originalBytecode = cr.getBytecode();
        if (this.transformedClasses == Collections.emptyMap()) {
            TestRun.mockFixture().addTransformedClass(classId, originalBytecode);
        } else {
            this.transformedClasses.put(classId, originalBytecode);
        }
        TestRun.mockFixture().registerMockedClass(this.capturedType.baseType);
        return ((ClassVisitor)modifier).toByteArray();
    }

    @Nullable
    public <C extends CaptureOfImplementations<?>> C getCaptureOfImplementationsIfApplicable(@Nonnull Class<?> aType) {
        if (this.typeMetadata != null && this.capturedType.baseType.isAssignableFrom(aType)) {
            return (C)this.captureOfImplementations;
        }
        return null;
    }

    public boolean areCapturedClasses(@Nonnull Class<?> mockedClass1, @Nonnull Class<?> mockedClass2) {
        Class<?> baseType = this.capturedType.baseType;
        return baseType.isAssignableFrom(mockedClass1) && baseType.isAssignableFrom(mockedClass2);
    }
}

