/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Expectations;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.FailureState;
import mockit.internal.expectations.FullVerificationPhase;
import mockit.internal.expectations.OrderedVerificationPhase;
import mockit.internal.expectations.PartiallyMockedInstances;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.PhasedExecutionState;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.PartialMocking;
import mockit.internal.expectations.state.ExecutingTest;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassNaming;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

public final class RecordAndReplayExecution {
    public static final ReentrantLock RECORD_OR_REPLAY_LOCK = new ReentrantLock();
    public static final ReentrantLock TEST_ONLY_PHASE_LOCK = new ReentrantLock();
    @Nullable
    private final PartialMocking partialMocking;
    @Nonnull
    private final PhasedExecutionState executionState;
    @Nonnull
    private final FailureState failureState;
    @Nullable
    private RecordPhase recordPhase;
    @Nullable
    private ReplayPhase replayPhase;
    @Nullable
    private BaseVerificationPhase verificationPhase;

    public RecordAndReplayExecution() {
        this.executionState = new PhasedExecutionState();
        this.partialMocking = null;
        this.discoverMockedTypesAndInstancesForMatchingOnInstance();
        this.failureState = new FailureState();
        this.replayPhase = new ReplayPhase(this.executionState, this.failureState);
    }

    public RecordAndReplayExecution(@Nonnull Expectations targetObject, Object ... instancesToBePartiallyMocked) {
        TestRun.enterNoMockingZone();
        ExecutingTest executingTest = TestRun.getExecutingTest();
        executingTest.setShouldIgnoreMockingCallbacks(true);
        try {
            RecordAndReplayExecution previous = executingTest.getPreviousRecordAndReplay();
            this.executionState = previous == null ? new PhasedExecutionState() : previous.executionState;
            this.failureState = new FailureState();
            this.recordPhase = new RecordPhase(this.executionState);
            executingTest.setRecordAndReplay(this);
            this.partialMocking = RecordAndReplayExecution.applyPartialMocking(instancesToBePartiallyMocked);
            this.discoverMockedTypesAndInstancesForMatchingOnInstance();
            TEST_ONLY_PHASE_LOCK.lock();
        }
        catch (RuntimeException e) {
            executingTest.setRecordAndReplay(null);
            throw e;
        }
        finally {
            executingTest.setShouldIgnoreMockingCallbacks(false);
            TestRun.exitNoMockingZone();
        }
    }

    private void discoverMockedTypesAndInstancesForMatchingOnInstance() {
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions != null) {
            List<Class<?>> fields = fieldTypeRedefinitions.getTargetClasses();
            ArrayList targetClasses = new ArrayList(fields);
            ParameterTypeRedefinitions paramTypeRedefinitions = TestRun.getExecutingTest().getParameterRedefinitions();
            if (paramTypeRedefinitions != null) {
                targetClasses.addAll(paramTypeRedefinitions.getTargetClasses());
            }
            this.executionState.instanceBasedMatching.discoverMockedTypesToMatchOnInstances(targetClasses);
            if (this.partialMocking != null && !this.partialMocking.targetInstances.isEmpty()) {
                this.executionState.partiallyMockedInstances = new PartiallyMockedInstances(this.partialMocking.targetInstances);
            }
        }
    }

    @Nullable
    private static PartialMocking applyPartialMocking(Object ... instances) {
        if (instances == null || instances.length == 0) {
            return null;
        }
        PartialMocking mocking = new PartialMocking();
        mocking.redefineTypes(instances);
        return mocking;
    }

    @Nullable
    public RecordPhase getRecordPhase() {
        return this.recordPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object recordOrReplay(@Nullable Object mock, int mockAccess, @Nonnull String classDesc, @Nonnull String mockDesc, @Nullable String genericSignature, int executionModeOrdinal, @Nullable Object[] args) throws Throwable {
        Object[] mockArgs = args == null ? Utilities.NO_ARGS : args;
        ExecutionMode executionMode = ExecutionMode.values()[executionModeOrdinal];
        if (RecordAndReplayExecution.notToBeMocked(mock, classDesc)) {
            return RecordAndReplayExecution.defaultReturnValue(mock, classDesc, mockDesc, genericSignature, executionMode, mockArgs);
        }
        ExecutingTest executingTest = TestRun.getExecutingTest();
        if (executingTest.isShouldIgnoreMockingCallbacks()) {
            return RecordAndReplayExecution.defaultReturnValue(executingTest, mock, classDesc, mockDesc, genericSignature, executionMode, mockArgs);
        }
        if (executingTest.shouldProceedIntoRealImplementation(mock, classDesc) || executionMode.isToExecuteRealImplementation(mock)) {
            return Void.class;
        }
        boolean isConstructor = mock != null && mockDesc.startsWith("<init>");
        RECORD_OR_REPLAY_LOCK.lock();
        try {
            RecordAndReplayExecution instance = executingTest.getOrCreateRecordAndReplay();
            if (isConstructor && instance.handleCallToConstructor(mock, classDesc)) {
                Object object = instance.getResultForConstructor(mock, executionMode);
                return object;
            }
            Object object = instance.getResult(mock, mockAccess, classDesc, mockDesc, genericSignature, executionMode, mockArgs);
            return object;
        }
        finally {
            RECORD_OR_REPLAY_LOCK.unlock();
        }
    }

    private static boolean notToBeMocked(@Nullable Object mock, @Nonnull String classDesc) {
        return RECORD_OR_REPLAY_LOCK.isHeldByCurrentThread() || TEST_ONLY_PHASE_LOCK.isLocked() && !TEST_ONLY_PHASE_LOCK.isHeldByCurrentThread() || !TestRun.mockFixture().isStillMocked(mock, classDesc);
    }

    @Nonnull
    private static Object defaultReturnValue(@Nullable Object mock, @Nonnull String classDesc, @Nonnull String nameAndDesc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode, @Nonnull Object[] args) {
        ExpectedInvocation invocation;
        Object cascadedInstance;
        Object rv;
        if (executionMode.isToExecuteRealImplementation(mock)) {
            return Void.class;
        }
        if (mock != null && (rv = ObjectMethods.evaluateOverride(mock, nameAndDesc, args)) != null) {
            return executionMode.isToExecuteRealObjectOverride(mock) ? Void.class : rv;
        }
        String returnTypeDesc = DefaultValues.getReturnTypeDesc(nameAndDesc);
        if (returnTypeDesc.charAt(0) == 'L' && (cascadedInstance = (invocation = new ExpectedInvocation(mock, classDesc, nameAndDesc, genericSignature, args)).getDefaultValueForReturnType()) != null) {
            return cascadedInstance;
        }
        return Void.class;
    }

    @Nullable
    private static Object defaultReturnValue(@Nonnull ExecutingTest executingTest, @Nullable Object mock, @Nonnull String classDesc, @Nonnull String nameAndDesc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode, @Nonnull Object[] args) throws Throwable {
        Expectation recordedExpectation;
        RecordAndReplayExecution execution = executingTest.getCurrentRecordAndReplay();
        if (execution != null && (recordedExpectation = execution.executionState.findExpectation(mock, classDesc, nameAndDesc, args)) != null) {
            return recordedExpectation.produceResult(mock, args);
        }
        return RecordAndReplayExecution.defaultReturnValue(mock, classDesc, nameAndDesc, genericSignature, executionMode, args);
    }

    private boolean handleCallToConstructor(@Nonnull Object mock, @Nonnull String classDesc) {
        if (this.replayPhase != null) {
            CaptureOfNewInstances paramTypeCaptures;
            ParameterTypeRedefinitions paramTypeRedefinitions = TestRun.getExecutingTest().getParameterRedefinitions();
            if (paramTypeRedefinitions != null && (paramTypeCaptures = paramTypeRedefinitions.getCaptureOfNewInstances()) != null && paramTypeCaptures.captureNewInstance(null, mock)) {
                return true;
            }
            FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
            if (fieldTypeRedefinitions != null && fieldTypeRedefinitions.captureNewInstanceForApplicableMockField(mock)) {
                return true;
            }
        }
        return RecordAndReplayExecution.isCallToSuperClassConstructor(mock, classDesc);
    }

    private static boolean isCallToSuperClassConstructor(@Nonnull Object mock, @Nonnull String calledClassDesc) {
        Class<?> mockedClass = mock.getClass();
        if (ClassNaming.isAnonymousClass(mockedClass) && (mockedClass = mockedClass.getSuperclass()) == Object.class) {
            return false;
        }
        String calledClassName = calledClassDesc.replace('/', '.');
        return !calledClassName.equals(mockedClass.getName());
    }

    @Nullable
    private Object getResultForConstructor(@Nonnull Object mock, @Nonnull ExecutionMode executionMode) {
        return executionMode == ExecutionMode.Regular || executionMode == ExecutionMode.Partial && this.replayPhase == null || TestRun.getExecutingTest().isInjectableMock(mock) ? null : Void.class;
    }

    @Nullable
    private Object getResult(@Nullable Object mock, int mockAccess, @Nonnull String classDesc, @Nonnull String mockDesc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode, @Nonnull Object[] args) throws Throwable {
        Phase currentPhase = this.getCurrentPhase();
        this.failureState.clearErrorThrown();
        boolean withRealImpl = executionMode.isWithRealImplementation(mock);
        Object result = currentPhase.handleInvocation(mock, mockAccess, classDesc, mockDesc, genericSignature, withRealImpl, args);
        this.failureState.reportErrorThrownIfAny();
        return result;
    }

    @Nonnull
    private Phase getCurrentPhase() {
        ReplayPhase replay = this.replayPhase;
        if (replay == null) {
            RecordPhase recordPhaseLocal = this.recordPhase;
            assert (recordPhaseLocal != null);
            return recordPhaseLocal;
        }
        BaseVerificationPhase verification = this.verificationPhase;
        if (verification != null) {
            return verification;
        }
        return replay;
    }

    @Nonnull
    public BaseVerificationPhase startVerifications(boolean inOrder, @Nullable Object[] mockedTypesAndInstancesToVerify) {
        assert (this.replayPhase != null);
        this.verificationPhase = inOrder ? new OrderedVerificationPhase(this.replayPhase) : (mockedTypesAndInstancesToVerify == null ? new UnorderedVerificationPhase(this.replayPhase) : new FullVerificationPhase(this.replayPhase, mockedTypesAndInstancesToVerify));
        return this.verificationPhase;
    }

    @Nullable
    public static Error endCurrentReplayIfAny() {
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        return instance == null ? null : instance.endExecution();
    }

    @Nullable
    private Error endExecution() {
        ReplayPhase replay;
        Error error;
        if (TEST_ONLY_PHASE_LOCK.isLocked()) {
            TEST_ONLY_PHASE_LOCK.unlock();
        }
        if ((error = (replay = this.switchFromRecordToReplayIfNotYet()).endExecution()) == null) {
            error = this.failureState.getErrorThrownInAnotherThreadIfAny();
        }
        if (error == null && this.verificationPhase != null) {
            error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
        }
        return error;
    }

    @Nonnull
    private ReplayPhase switchFromRecordToReplayIfNotYet() {
        if (this.replayPhase == null) {
            this.recordPhase = null;
            this.replayPhase = new ReplayPhase(this.executionState, this.failureState);
        }
        return this.replayPhase;
    }

    @Nullable
    TestOnlyPhase getCurrentTestOnlyPhase() {
        return this.recordPhase != null ? this.recordPhase : this.verificationPhase;
    }

    void endInvocations() {
        TEST_ONLY_PHASE_LOCK.unlock();
        if (this.verificationPhase == null) {
            this.switchFromRecordToReplayIfNotYet();
        } else {
            Error error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
            if (error != null) {
                throw error;
            }
        }
    }
}

