/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.FailureState;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.PhasedExecutionState;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.UnexpectedInvocation;

final class ReplayPhase
extends Phase {
    @Nonnull
    final FailureState failureState;
    @Nonnull
    final List<Expectation> invocations;
    @Nonnull
    final List<Object> invocationInstances;
    @Nonnull
    final List<Object[]> invocationArguments;

    ReplayPhase(@Nonnull PhasedExecutionState executionState, @Nonnull FailureState failureState) {
        super(executionState);
        this.failureState = failureState;
        this.invocations = new ArrayList<Expectation>();
        this.invocationInstances = new ArrayList<Object>();
        this.invocationArguments = new ArrayList<Object[]>();
    }

    @Override
    @Nullable
    Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        Object replacementInstance;
        Expectation expectation = this.executionState.findExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        Object object = replacementInstance = mock == null ? null : this.executionState.equivalentInstances.getReplacementInstanceForMethodInvocation(mock, mockNameAndDesc);
        if (expectation == null) {
            expectation = this.createExpectation(replacementInstance == null ? mock : replacementInstance, mockAccess, mockClassDesc, mockNameAndDesc, genericSignature, args);
        } else if (expectation.recordPhase != null) {
            this.registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(mock, expectation.invocation);
        }
        this.invocations.add(expectation);
        this.invocationInstances.add(mock);
        this.invocationArguments.add(args);
        expectation.constraints.incrementInvocationCount();
        return this.produceResult(expectation, mock, withRealImpl, args);
    }

    @Nonnull
    private Expectation createExpectation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, @Nonnull Object[] args) {
        ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, genericSignature, args);
        Expectation expectation = new Expectation(invocation);
        this.executionState.addExpectation(expectation);
        return expectation;
    }

    private void registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(@Nullable Object mock, @Nonnull ExpectedInvocation invocation) {
        if (mock != null && invocation.isConstructor()) {
            Map<Object, Object> instanceMap = this.getInstanceMap();
            instanceMap.put(mock, invocation.instance);
        }
    }

    @Nullable
    private Object produceResult(@Nonnull Expectation expectation, @Nullable Object mock, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        boolean executeRealImpl;
        boolean bl = executeRealImpl = withRealImpl && expectation.recordPhase == null;
        if (executeRealImpl) {
            expectation.executedRealImplementation = true;
            return Void.class;
        }
        if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            UnexpectedInvocation unexpectedInvocation = expectation.invocation.errorForUnexpectedInvocation(args);
            this.failureState.setErrorThrown(unexpectedInvocation);
            return null;
        }
        return expectation.produceResult(mock, args);
    }

    @Nullable
    Error endExecution() {
        return this.getErrorForFirstExpectationThatIsMissing();
    }

    @Nullable
    private Error getErrorForFirstExpectationThatIsMissing() {
        List<Expectation> notStrictExpectations = this.executionState.expectations;
        for (Expectation notStrict : notStrictExpectations) {
            InvocationConstraints constraints = notStrict.constraints;
            if (!constraints.isInvocationCountLessThanMinimumExpected()) continue;
            List<ExpectedInvocation> nonMatchingInvocations = this.getNonMatchingInvocations(notStrict);
            return constraints.errorForMissingExpectations(notStrict.invocation, nonMatchingInvocations);
        }
        return null;
    }

    @Nonnull
    private List<ExpectedInvocation> getNonMatchingInvocations(@Nonnull Expectation unsatisfiedExpectation) {
        ExpectedInvocation unsatisfiedInvocation = unsatisfiedExpectation.invocation;
        ArrayList<ExpectedInvocation> nonMatchingInvocations = new ArrayList<ExpectedInvocation>();
        for (Expectation replayedExpectation : this.invocations) {
            ExpectedInvocation replayedInvocation = replayedExpectation.invocation;
            if (replayedExpectation == unsatisfiedExpectation || !replayedInvocation.isMatch(unsatisfiedInvocation)) continue;
            nonMatchingInvocations.add(replayedInvocation);
        }
        return nonMatchingInvocations;
    }
}

