/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.util.ObjectMethods;

public final class ArgumentMismatch {
    @Nonnull
    private final StringBuilder out = new StringBuilder(50);
    @Nullable
    private String parameterType;

    @Nullable
    public String getParameterType() {
        return this.parameterType;
    }

    public String toString() {
        return this.out.toString();
    }

    @Nonnull
    public ArgumentMismatch append(char c) {
        this.out.append(c);
        return this;
    }

    @Nonnull
    public ArgumentMismatch append(int i) {
        this.out.append(i);
        return this;
    }

    @Nonnull
    public ArgumentMismatch append(double d) {
        this.out.append(d);
        return this;
    }

    @Nonnull
    public ArgumentMismatch append(@Nullable CharSequence str) {
        this.out.append(str);
        return this;
    }

    public void appendFormatted(@Nullable String parameterTypeName, @Nullable Object argumentValue, @Nullable ArgumentMatcher<?> matcher) {
        if (matcher == null) {
            this.appendFormatted(argumentValue);
        } else {
            this.parameterType = parameterTypeName;
            matcher.writeMismatchPhrase(this);
        }
    }

    void appendFormatted(@Nullable Object value) {
        if (value == null) {
            this.out.append("null");
        } else if (value instanceof CharSequence) {
            this.appendCharacters((CharSequence)value);
        } else if (value instanceof Character) {
            this.out.append('\'');
            this.appendEscapedOrPlainCharacter('\'', ((Character)value).charValue());
            this.out.append('\'');
        } else if (value instanceof Byte) {
            this.out.append(value).append('b');
        } else if (value instanceof Short) {
            this.out.append(value).append('s');
        } else if (value instanceof Long) {
            this.out.append(value).append('L');
        } else if (value instanceof Float) {
            this.out.append(value).append('F');
        } else if (value instanceof Number || value instanceof Boolean) {
            this.out.append(value);
        } else if (value.getClass().isArray()) {
            this.appendArray(value);
        } else if (value instanceof ArgumentMatcher) {
            ((ArgumentMatcher)value).writeMismatchPhrase(this);
        } else {
            this.appendArbitraryArgument(value);
        }
    }

    private void appendArray(@Nonnull Object array) {
        this.out.append('[');
        String separator = "";
        int n = Array.getLength(array);
        for (int i = 0; i < n; ++i) {
            Object nextValue = Array.get(array, i);
            this.out.append(separator);
            this.appendFormatted(nextValue);
            separator = ", ";
        }
        this.out.append(']');
    }

    private void appendCharacters(@Nonnull CharSequence characters) {
        this.out.append('\"');
        int n = characters.length();
        for (int i = 0; i < n; ++i) {
            char c = characters.charAt(i);
            this.appendEscapedOrPlainCharacter('\"', c);
        }
        this.out.append('\"');
    }

    private void appendEscapedOrPlainCharacter(char quoteCharacter, char c) {
        if (c == quoteCharacter) {
            this.out.append('\\').append(c);
        } else {
            switch (c) {
                case '\t': {
                    this.out.append("\\t");
                    break;
                }
                case '\n': {
                    this.out.append("\\n");
                    break;
                }
                case '\r': {
                    this.out.append("\\r");
                    break;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
    }

    private void appendArbitraryArgument(@Nonnull Object value) {
        Method toStringMethod;
        Class<?> valueClass = value.getClass();
        try {
            toStringMethod = valueClass.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            return;
        }
        if (toStringMethod.getDeclaringClass() == Object.class) {
            this.out.append(value);
        } else {
            String valueAsString = value.toString();
            if (valueAsString != null && !valueAsString.isEmpty()) {
                this.appendCharacters(valueAsString);
            } else {
                this.out.append(ObjectMethods.objectIdentity(value));
            }
        }
    }

    public void appendFormatted(@Nonnull Object[] values) {
        String separator = "";
        for (Object value : values) {
            this.append(separator).appendFormatted(value);
            separator = ", ";
        }
    }
}

