/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.AlwaysTrueMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;
import mockit.internal.expectations.argumentMatching.EqualityMatcher;
import mockit.internal.expectations.argumentMatching.ReflectiveMatcher;
import mockit.internal.expectations.invocation.InvocationArguments;

abstract class ArgumentValuesAndMatchers {
    @Nonnull
    final InvocationArguments signature;
    @Nonnull
    Object[] values;
    @Nullable
    List<ArgumentMatcher<?>> matchers;

    ArgumentValuesAndMatchers(@Nonnull InvocationArguments signature, @Nonnull Object[] values) {
        this.signature = signature;
        this.values = values;
    }

    final void setValuesWithNoMatchers(@Nonnull Object[] argsToVerify) {
        this.setValuesAndMatchers(argsToVerify, null);
    }

    @Nonnull
    final Object[] prepareForVerification(@Nonnull Object[] argsToVerify, @Nullable List<ArgumentMatcher<?>> matchersToUse) {
        Object[] replayArgs = this.values;
        this.setValuesAndMatchers(argsToVerify, matchersToUse);
        return replayArgs;
    }

    final void setValuesAndMatchers(@Nonnull Object[] argsToVerify, @Nullable List<ArgumentMatcher<?>> matchersToUse) {
        this.values = argsToVerify;
        this.matchers = matchersToUse;
    }

    @Nullable
    final ArgumentMatcher<?> getArgumentMatcher(@Nonnegative int parameterIndex) {
        ArgumentMatcher<?> matcher;
        if (this.matchers == null) {
            return null;
        }
        ArgumentMatcher<?> argumentMatcher = matcher = parameterIndex < this.matchers.size() ? this.matchers.get(parameterIndex) : null;
        if (matcher == null && parameterIndex < this.values.length && this.values[parameterIndex] == null) {
            matcher = AlwaysTrueMatcher.ANY_VALUE;
        }
        return matcher;
    }

    abstract boolean isMatch(@Nonnull Object[] var1, @Nonnull Map<Object, Object> var2);

    static boolean areEqual(@Nonnull Object[] expectedValues, @Nonnull Object[] actualValues, @Nonnegative int count, @Nonnull Map<Object, Object> instanceMap) {
        for (int i = 0; i < count; ++i) {
            if (!ArgumentValuesAndMatchers.isNotEqual(expectedValues[i], actualValues[i], instanceMap)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotEqual(@Nullable Object expected, @Nullable Object actual, @Nonnull Map<Object, Object> instanceMap) {
        return actual == null == (expected != null) || actual != null && actual != expected && expected != instanceMap.get(actual) && !EqualityMatcher.areEqualWhenNonNull(actual, expected);
    }

    abstract boolean hasEquivalentMatchers(@Nonnull ArgumentValuesAndMatchers var1);

    private static boolean equivalentMatches(@Nonnull ArgumentMatcher<?> matcher1, @Nullable Object arg1, @Nonnull ArgumentMatcher<?> matcher2, @Nullable Object arg2) {
        boolean matcher1MatchesArg2 = matcher1.matches(arg2);
        boolean matcher2MatchesArg1 = matcher2.matches(arg1);
        if (arg1 != null && arg2 != null && matcher1MatchesArg2 && matcher2MatchesArg1) {
            return true;
        }
        if (arg1 == arg2 && matcher1MatchesArg2 == matcher2MatchesArg1) {
            ArgumentMismatch desc1 = new ArgumentMismatch();
            matcher1.writeMismatchPhrase(desc1);
            ArgumentMismatch desc2 = new ArgumentMismatch();
            matcher2.writeMismatchPhrase(desc2);
            return desc1.toString().equals(desc2.toString());
        }
        return false;
    }

    final <M1 extends ArgumentMatcher<M1>, M2 extends ArgumentMatcher<M2>> int indexOfFirstValueAfterEquivalentMatchers(@Nonnull ArgumentValuesAndMatchers other) {
        int i;
        List<ArgumentMatcher<?>> otherMatchers = other.matchers;
        if (this.hasDifferentAmountOfMatchers(otherMatchers)) {
            return -1;
        }
        int m = this.matchers.size();
        for (i = 0; i < m; ++i) {
            ArgumentMatcher<?> matcher1 = this.matchers.get(i);
            ArgumentMatcher<?> matcher2 = otherMatchers.get(i);
            if (!(matcher1 == null || matcher2 == null ? !EqualityMatcher.areEqual(this.values[i], other.values[i]) : matcher1 != matcher2 && (matcher1.getClass() != matcher2.getClass() || !matcher1.same(matcher2) && this.areNonEquivalentMatches(other, matcher1, matcher2, i)))) continue;
            return -1;
        }
        return i;
    }

    private boolean hasDifferentAmountOfMatchers(@Nullable List<ArgumentMatcher<?>> otherMatchers) {
        return otherMatchers == null || this.matchers == null || otherMatchers.size() != this.matchers.size();
    }

    private boolean areNonEquivalentMatches(@Nonnull ArgumentValuesAndMatchers other, @Nonnull ArgumentMatcher<?> matcher1, @Nonnull ArgumentMatcher<?> matcher2, @Nonnegative int matcherIndex) {
        return matcher1.getClass() == ReflectiveMatcher.class || !ArgumentValuesAndMatchers.equivalentMatches(matcher1, this.values[matcherIndex], matcher2, other.values[matcherIndex]);
    }

    @Nonnull
    final String toString(@Nonnull List<String> parameterTypes) {
        ArgumentMismatch desc = new ArgumentMismatch();
        int parameterCount = this.values.length;
        if (parameterCount > 0) {
            if (this.matchers == null) {
                desc.appendFormatted(this.values);
            } else {
                String sep = "";
                for (int i = 0; i < parameterCount; ++i) {
                    ArgumentMatcher<?> matcher = this.getArgumentMatcher(i);
                    String parameterType = parameterTypes.get(i);
                    desc.append(sep).appendFormatted(parameterType, this.values[i], matcher);
                    sep = ", ";
                }
            }
            desc.append(')');
        }
        return desc.toString();
    }
}

