/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.Invocation;
import mockit.asm.types.JavaType;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.DelegateInvocation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResult;
import mockit.internal.expectations.invocation.ReturnTypeConversion;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.reflection.ParameterReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.TypeDescriptor;

final class DelegatedResult
extends InvocationResult {
    private static final Object[] NO_ARGS = new Object[0];
    @Nonnull
    private final ExpectedInvocation recordedInvocation;
    @Nonnull
    private final Object targetObject;
    @Nonnull
    private final Method methodToInvoke;
    @Nonnull
    private final Class<?> targetReturnType;
    private final boolean hasInvocationParameter;
    private final int numberOfRegularParameters;

    DelegatedResult(@Nonnull ExpectedInvocation recordedInvocation, @Nonnull Delegate<?> delegate) {
        this.recordedInvocation = recordedInvocation;
        this.targetObject = delegate;
        this.methodToInvoke = MethodReflection.findNonPrivateHandlerMethod(delegate);
        JavaType returnType = JavaType.getReturnType(recordedInvocation.getMethodNameAndDescription());
        this.targetReturnType = TypeDescriptor.getClassForType(returnType);
        Class<?>[] parameters = this.methodToInvoke.getParameterTypes();
        int n = parameters.length;
        this.hasInvocationParameter = n > 0 && parameters[0] == Invocation.class;
        this.numberOfRegularParameters = this.hasInvocationParameter ? n - 1 : n;
    }

    @Override
    @Nullable
    Object produceResult(@Nullable Object invokedObject, @Nonnull ExpectedInvocation invocation, @Nonnull InvocationConstraints constraints, @Nonnull Object[] args) {
        Object[] delegateArgs = this.numberOfRegularParameters == 0 ? NO_ARGS : args;
        return this.hasInvocationParameter ? this.invokeMethodWithContext(invokedObject, invocation, constraints, args, delegateArgs) : this.executeMethodToInvoke(delegateArgs);
    }

    @Nullable
    private Object invokeMethodWithContext(@Nullable Object mockOrRealObject, @Nonnull ExpectedInvocation expectedInvocation, @Nonnull InvocationConstraints constraints, @Nonnull Object[] invokedArgs, @Nonnull Object[] delegateArgs) {
        DelegateInvocation delegateInvocation = new DelegateInvocation(mockOrRealObject, invokedArgs, expectedInvocation, constraints);
        Object[] delegateArgsWithInvocation = ParameterReflection.argumentsWithExtraFirstValue(delegateArgs, delegateInvocation);
        Class<Void> result = this.executeMethodToInvoke(delegateArgsWithInvocation);
        return expectedInvocation.isConstructor() && TestRun.getExecutingTest().isProceedingIntoRealImplementation() ? Void.class : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object executeMethodToInvoke(@Nonnull Object[] args) {
        ReentrantLock reentrantLock = RecordAndReplayExecution.RECORD_OR_REPLAY_LOCK;
        if (!reentrantLock.isHeldByCurrentThread()) {
            return this.executeTargetMethod(args);
        }
        reentrantLock.unlock();
        try {
            Object object = this.executeTargetMethod(args);
            return object;
        }
        finally {
            reentrantLock.lock();
        }
    }

    @Nullable
    private Object executeTargetMethod(@Nonnull Object[] args) {
        Object returnValue = MethodReflection.invoke(this.targetObject, this.methodToInvoke, args);
        Class<?> fromReturnType = this.methodToInvoke.getReturnType();
        if (returnValue == null || this.targetReturnType.isInstance(returnValue)) {
            if (fromReturnType == Void.TYPE && fromReturnType != this.targetReturnType && this.targetReturnType.isPrimitive()) {
                String returnTypeName = MethodReflection.JAVA_LANG.matcher(this.targetReturnType.getName()).replaceAll("");
                MethodFormatter methodDesc = new MethodFormatter(this.recordedInvocation.getClassDesc(), this.recordedInvocation.getMethodNameAndDescription());
                String msg = "void return type incompatible with return type " + returnTypeName + " of " + methodDesc;
                throw new IllegalArgumentException(msg);
            }
            return returnValue;
        }
        ReturnTypeConversion typeConversion = new ReturnTypeConversion(this.recordedInvocation, this.targetReturnType, returnValue);
        return typeConversion.getConvertedValue();
    }
}

