/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.expectations.invocation.DelegatedResult;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResult;

public final class InvocationResults {
    @Nonnull
    private final ExpectedInvocation invocation;
    @Nonnull
    private final InvocationConstraints constraints;
    @Nullable
    private InvocationResult currentResult;
    @Nullable
    private InvocationResult lastResult;
    @Nonnegative
    private int resultCount;

    public InvocationResults(@Nonnull ExpectedInvocation invocation, @Nonnull InvocationConstraints constraints) {
        this.invocation = invocation;
        this.constraints = constraints;
    }

    public void addReturnValue(@Nullable Object value) {
        if (value instanceof Delegate) {
            this.addDelegatedResult((Delegate)value);
        } else {
            this.addNewReturnValueResult(value);
        }
    }

    public void addDelegatedResult(@Nonnull Delegate<?> delegate) {
        DelegatedResult result = new DelegatedResult(this.invocation, delegate);
        this.addResult(result);
    }

    private void addNewReturnValueResult(@Nullable Object value) {
        InvocationResult.ReturnValueResult result = new InvocationResult.ReturnValueResult(value);
        this.addResult(result);
    }

    public void addReturnValueResult(@Nullable Object value) {
        this.addNewReturnValueResult(value);
    }

    public void addReturnValues(Object ... values) {
        for (Object value : values) {
            this.addReturnValue(value);
        }
    }

    void addResults(@Nonnull Object array) {
        int n = Array.getLength(array);
        for (int i = 0; i < n; ++i) {
            Object value = Array.get(array, i);
            this.addConsecutiveResult(value);
        }
    }

    private void addConsecutiveResult(@Nullable Object result) {
        if (result instanceof Throwable) {
            this.addThrowable((Throwable)result);
        } else {
            this.addReturnValue(result);
        }
    }

    void addResults(@Nonnull Iterable<?> values) {
        for (Object value : values) {
            this.addConsecutiveResult(value);
        }
    }

    void addDeferredResults(@Nonnull Iterator<?> values) {
        InvocationResult.DeferredResults result = new InvocationResult.DeferredResults(values);
        this.addResult(result);
        this.constraints.setUnlimitedMaxInvocations();
    }

    public void addThrowable(@Nonnull Throwable t) {
        this.addResult(new InvocationResult.ThrowableResult(t));
    }

    private void addResult(@Nonnull InvocationResult result) {
        ++this.resultCount;
        this.constraints.adjustMaxInvocations(this.resultCount);
        if (this.currentResult == null) {
            this.currentResult = result;
        } else {
            assert (this.lastResult != null);
            this.lastResult.next = result;
        }
        this.lastResult = result;
    }

    @Nullable
    public Object produceResult(@Nullable Object invokedObject, @Nonnull Object[] invocationArgs) throws Throwable {
        InvocationResult resultToBeProduced = this.currentResult;
        if (resultToBeProduced == null) {
            return null;
        }
        InvocationResult nextResult = resultToBeProduced.next;
        if (nextResult != null) {
            this.currentResult = nextResult;
        }
        return resultToBeProduced.produceResult(invokedObject, this.invocation, this.constraints, invocationArgs);
    }
}

