/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.invocation.InvocationResults;
import mockit.internal.util.Utilities;

final class MultiValuedConversion {
    @Nonnull
    private final InvocationResults invocationResults;
    @Nonnull
    private final Class<?> returnType;
    @Nonnull
    private final Object valueToReturn;

    MultiValuedConversion(@Nonnull InvocationResults invocationResults, @Nonnull Class<?> returnType, @Nonnull Object valueToReturn) {
        this.invocationResults = invocationResults;
        this.returnType = returnType;
        this.valueToReturn = valueToReturn;
    }

    void addMultiValuedResultBasedOnTheReturnType(boolean valueIsArray) {
        if (this.returnType == Void.TYPE) {
            this.addMultiValuedResult(valueIsArray);
        } else if (this.returnType == Object.class) {
            this.invocationResults.addReturnValueResult(this.valueToReturn);
        } else if (!valueIsArray || !this.addCollectionOrMapWithElementsFromArray()) {
            if (this.hasReturnOfDifferentType()) {
                this.addMultiValuedResult(valueIsArray);
            } else {
                this.invocationResults.addReturnValueResult(this.valueToReturn);
            }
        }
    }

    private void addMultiValuedResult(boolean valueIsArray) {
        if (valueIsArray) {
            this.invocationResults.addResults(this.valueToReturn);
        } else if (this.valueToReturn instanceof Iterable) {
            if (Utilities.JAVA8 && this.valueToReturn instanceof Collection && this.returnType.isAssignableFrom(Stream.class)) {
                this.invocationResults.addReturnValueResult(((Collection)this.valueToReturn).stream());
            } else {
                this.invocationResults.addResults((Iterable)this.valueToReturn);
            }
        } else {
            this.invocationResults.addDeferredResults((Iterator)this.valueToReturn);
        }
    }

    private boolean hasReturnOfDifferentType() {
        return !this.returnType.isArray() && !Iterable.class.isAssignableFrom(this.returnType) && !Iterator.class.isAssignableFrom(this.returnType) && !this.returnType.isAssignableFrom(this.valueToReturn.getClass());
    }

    private boolean addCollectionOrMapWithElementsFromArray() {
        int n = Array.getLength(this.valueToReturn);
        Stream<?> values = null;
        if (this.returnType.isAssignableFrom(ListIterator.class)) {
            ArrayList<Object> list = new ArrayList<Object>(n);
            this.addArrayElements(list, n);
            values = list.listIterator();
        } else if (this.returnType.isAssignableFrom(List.class)) {
            values = this.addArrayElements(new ArrayList<Object>(n), n);
        } else if (this.returnType.isAssignableFrom(Set.class)) {
            values = this.addArrayElements(new LinkedHashSet<Object>(n), n);
        } else if (this.returnType.isAssignableFrom(SortedSet.class)) {
            values = this.addArrayElements(new TreeSet<Object>(), n);
        } else if (this.returnType.isAssignableFrom(Map.class)) {
            values = this.addArrayElements(new LinkedHashMap<Object, Object>(n), n);
        } else if (this.returnType.isAssignableFrom(SortedMap.class)) {
            values = this.addArrayElements(new TreeMap<Object, Object>(), n);
        } else if (Utilities.JAVA8 && this.returnType.isAssignableFrom(Stream.class)) {
            values = this.addArrayElements(new ArrayList<Object>(n), n).stream();
        }
        if (values != null) {
            this.invocationResults.addReturnValue(values);
            return true;
        }
        return false;
    }

    @Nonnull
    private Collection<?> addArrayElements(@Nonnull Collection<Object> values, @Nonnegative int elementCount) {
        for (int i = 0; i < elementCount; ++i) {
            Object element = Array.get(this.valueToReturn, i);
            values.add(element);
        }
        return values;
    }

    @Nullable
    private Object addArrayElements(@Nonnull Map<Object, Object> values, @Nonnegative int elementPairCount) {
        for (int i = 0; i < elementPairCount; ++i) {
            Object keyAndValue = Array.get(this.valueToReturn, i);
            if (keyAndValue == null || !keyAndValue.getClass().isArray()) {
                return null;
            }
            Object key = Array.get(keyAndValue, 0);
            Object element = Array.getLength(keyAndValue) > 1 ? Array.get(keyAndValue, 1) : null;
            values.put(key, element);
        }
        return values;
    }
}

