/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.asm.types.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.expectations.mocking.MockedClassModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public class CaptureOfNewInstances
extends CaptureOfImplementations<MockedType> {
    @Nonnull
    private final Map<Class<?>, List<Capture>> baseTypeToCaptures = new HashMap();

    CaptureOfNewInstances() {
    }

    @Nonnull
    protected final Collection<List<Capture>> getCapturesForAllBaseTypes() {
        return this.baseTypeToCaptures.values();
    }

    @Override
    @Nonnull
    protected BaseClassModifier createModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, @Nullable MockedType typeMetadata) {
        MockedClassModifier modifier = new MockedClassModifier(cl, cr, typeMetadata);
        String baseTypeDesc = JavaType.getInternalName(baseType);
        modifier.setClassNameForCapturedInstanceMethods(baseTypeDesc);
        return modifier;
    }

    @Override
    protected void redefineClass(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        ClassDefinition newClassDefinition = new ClassDefinition(realClass, modifiedClass);
        Startup.redefineMethods(newClassDefinition);
        MockFixture mockFixture = TestRun.mockFixture();
        mockFixture.addRedefinedClass(newClassDefinition);
        mockFixture.registerMockedClass(realClass);
    }

    void registerCaptureOfNewInstances(@Nonnull MockedType typeMetadata, @Nullable Object mockInstance) {
        List<Capture> captures;
        Class<?> baseType = typeMetadata.getClassType();
        if (!typeMetadata.isFinalFieldOrParameter()) {
            this.makeSureAllSubtypesAreModified(typeMetadata);
        }
        if ((captures = this.baseTypeToCaptures.get(baseType)) == null) {
            captures = new ArrayList<Capture>();
            this.baseTypeToCaptures.put(baseType, captures);
        }
        captures.add(new Capture(typeMetadata, mockInstance));
    }

    void makeSureAllSubtypesAreModified(@Nonnull MockedType typeMetadata) {
        Class<?> baseType = typeMetadata.getClassType();
        this.makeSureAllSubtypesAreModified(baseType, typeMetadata.fieldFromTestClass, typeMetadata);
    }

    public boolean captureNewInstance(@Nullable Object fieldOwner, @Nonnull Object mock) {
        boolean constructorModifiedForCaptureOnly;
        Class<?> mockedClass = mock.getClass();
        List<Capture> captures = this.baseTypeToCaptures.get(mockedClass);
        boolean bl = constructorModifiedForCaptureOnly = captures == null;
        if (constructorModifiedForCaptureOnly && (captures = this.findCaptures(mockedClass)) == null) {
            return false;
        }
        Capture captureFound = CaptureOfNewInstances.findCapture(fieldOwner, mock, captures);
        if (captureFound != null) {
            if (captureFound.typeMetadata.injectable) {
                TestRun.getExecutingTest().addCapturedInstanceForInjectableMock(captureFound.originalMockInstance, mock);
                constructorModifiedForCaptureOnly = true;
            } else {
                TestRun.getExecutingTest().addCapturedInstance(captureFound.originalMockInstance, mock);
            }
        }
        return constructorModifiedForCaptureOnly;
    }

    @Nullable
    private List<Capture> findCaptures(@Nonnull Class<?> mockedClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = mockedClass.getInterfaces()) {
            List<Capture> found = this.baseTypeToCaptures.get(anInterface);
            if (found == null) continue;
            return found;
        }
        Class<?> superclass = mockedClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        List<Capture> found = this.baseTypeToCaptures.get(superclass);
        return found != null ? found : this.findCaptures(superclass);
    }

    @Nullable
    private static Capture findCapture(@Nullable Object fieldOwner, @Nonnull Object mock, @Nonnull List<Capture> captures) {
        for (Capture capture : captures) {
            if (capture.isInstanceAlreadyCaptured(mock)) break;
            if (!capture.captureInstance(fieldOwner, mock)) continue;
            return capture;
        }
        return null;
    }

    public void cleanUp() {
        this.baseTypeToCaptures.clear();
    }

    protected static final class Capture {
        @Nonnull
        final MockedType typeMetadata;
        @Nullable
        private Object originalMockInstance;
        @Nonnull
        private final List<Object> instancesCaptured;

        private Capture(@Nonnull MockedType typeMetadata, @Nullable Object originalMockInstance) {
            this.typeMetadata = typeMetadata;
            this.originalMockInstance = originalMockInstance;
            this.instancesCaptured = new ArrayList<Object>(4);
        }

        private boolean isInstanceAlreadyCaptured(@Nonnull Object mock) {
            return Utilities.containsReference(this.instancesCaptured, mock);
        }

        private boolean captureInstance(@Nullable Object fieldOwner, @Nonnull Object instance) {
            if (this.instancesCaptured.size() < this.typeMetadata.getMaxInstancesToCapture()) {
                if (fieldOwner != null && this.typeMetadata.field != null && this.originalMockInstance == null) {
                    this.originalMockInstance = FieldReflection.getFieldValue(this.typeMetadata.field, fieldOwner);
                }
                this.instancesCaptured.add(instance);
                return true;
            }
            return false;
        }

        void reset() {
            this.originalMockInstance = null;
            this.instancesCaptured.clear();
        }
    }
}

