/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.fields.FieldVisitor;
import mockit.asm.jvmConstants.Access;
import mockit.asm.metadata.ClassMetadataReader;
import mockit.asm.methods.MethodVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.classGeneration.MockedTypeInfo;
import mockit.internal.reflection.GenericTypeReflection;

public final class InterfaceImplementationGenerator
extends BaseClassModifier {
    private static final int CLASS_ACCESS = 17;
    private static final EnumSet<ClassMetadataReader.Attribute> SIGNATURE = EnumSet.of(ClassMetadataReader.Attribute.Signature);
    @Nonnull
    private final MockedTypeInfo mockedTypeInfo;
    @Nonnull
    private final String implementationClassDesc;
    @Nonnull
    private final List<String> implementedMethods;
    private String interfaceName;
    private String methodOwner;
    @Nullable
    private String[] initialSuperInterfaces;

    public InterfaceImplementationGenerator(@Nonnull ClassReader cr, @Nonnull Type mockedType, @Nonnull String implementationClassName) {
        super(cr);
        this.mockedTypeInfo = new MockedTypeInfo(mockedType);
        this.implementationClassDesc = implementationClassName.replace('.', '/');
        this.implementedMethods = new ArrayList<String>();
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        this.interfaceName = name;
        this.methodOwner = name;
        this.initialSuperInterfaces = additionalInfo.interfaces;
        ClassInfo implementationClassInfo = new ClassInfo();
        String signature = additionalInfo.signature;
        implementationClassInfo.signature = signature == null ? null : signature + this.mockedTypeInfo.implementationSignature;
        implementationClassInfo.interfaces = new String[]{name};
        implementationClassInfo.superName = additionalInfo.superName;
        super.visit(version, 17, this.implementationClassDesc, implementationClassInfo);
        this.generateNoArgsConstructor();
    }

    private void generateNoArgsConstructor() {
        this.mw = this.cw.visitMethod(1, "<init>", "()V", null, null);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        this.generateEmptyImplementation();
    }

    @Override
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return null;
    }

    @Override
    public void visitInnerClass(@Nonnull String name, String outerName, String innerName, int access) {
    }

    @Override
    @Nullable
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        return null;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (!Access.isSynthetic(access)) {
            this.generateMethodImplementation(access, name, desc, signature, exceptions);
        }
        return null;
    }

    private void generateMethodImplementation(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String methodNameAndDesc;
        if (!Modifier.isStatic(access) && !this.implementedMethods.contains(methodNameAndDesc = name + desc)) {
            this.generateMethodBody(access, name, desc, signature, exceptions);
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    private void generateMethodBody(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String subInterfaceOverride;
        this.mw = this.cw.visitMethod(1, name, desc, signature, exceptions);
        String className = null;
        if (signature != null && (subInterfaceOverride = this.getSubInterfaceOverride(this.mockedTypeInfo.genericTypeMap, name, signature)) != null) {
            className = this.interfaceName;
            desc = subInterfaceOverride.substring(name.length());
            signature = null;
        }
        if (className == null) {
            className = this.isOverrideOfMethodFromSuperInterface(name, desc) ? this.interfaceName : this.methodOwner;
        }
        this.generateDirectCallToHandler(className, access, name, desc, signature);
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitMaxStack(1);
    }

    @Nullable
    private String getSubInterfaceOverride(@Nonnull GenericTypeReflection genericTypeMap, @Nonnull String name, @Nonnull String genericSignature) {
        if (!this.implementedMethods.isEmpty()) {
            GenericTypeReflection.GenericSignature parsedSignature = genericTypeMap.parseSignature(genericSignature);
            for (String implementedMethod : this.implementedMethods) {
                if (!InterfaceImplementationGenerator.sameMethodName(implementedMethod, name) || !parsedSignature.satisfiesSignature(implementedMethod)) continue;
                return implementedMethod;
            }
        }
        return null;
    }

    private static boolean sameMethodName(@Nonnull String implementedMethod, @Nonnull String name) {
        return implementedMethod.startsWith(name) && implementedMethod.charAt(name.length()) == '(';
    }

    private boolean isOverrideOfMethodFromSuperInterface(@Nonnull String name, @Nonnull String desc) {
        if (!this.implementedMethods.isEmpty()) {
            int p = desc.lastIndexOf(41);
            String descNoReturnType = desc.substring(0, p + 1);
            for (String implementedMethod : this.implementedMethods) {
                if (!InterfaceImplementationGenerator.sameMethodName(implementedMethod, name) || !implementedMethod.contains(descNoReturnType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitEnd() {
        assert (this.initialSuperInterfaces != null);
        for (String superInterface : this.initialSuperInterfaces) {
            this.generateImplementationsForInterfaceMethodsRecurringToSuperInterfaces(superInterface);
        }
    }

    private void generateImplementationsForInterfaceMethodsRecurringToSuperInterfaces(@Nonnull String anInterface) {
        this.methodOwner = anInterface;
        byte[] interfaceBytecode = ClassFile.getClassFile(anInterface);
        ClassMetadataReader cmr = new ClassMetadataReader(interfaceBytecode, SIGNATURE);
        String[] superInterfaces = cmr.getInterfaces();
        for (ClassMetadataReader.MethodInfo method : cmr.getMethods()) {
            this.generateMethodImplementation(method.accessFlags, method.name, method.desc, method.signature, null);
        }
        if (superInterfaces != null) {
            for (String superInterface : superInterfaces) {
                this.generateImplementationsForInterfaceMethodsRecurringToSuperInterfaces(superInterface);
            }
        }
    }
}

