/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.controlFlow.Label;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.types.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.expectations.MockingFilters;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

final class MockedClassModifier
extends BaseClassModifier {
    private static final int METHOD_ACCESS_MASK = 5122;
    private static final int PUBLIC_OR_PROTECTED = 5;
    private static final boolean NATIVE_UNSUPPORTED = !Utilities.HOTSPOT_VM;
    private static final Map<String, String> FILTERS = new HashMap<String, String>(4);
    @Nullable
    private final MockedType mockedType;
    private String className;
    private String methodSignature;
    @Nullable
    private String baseClassNameForCapturedInstanceMethods;
    @Nonnull
    private ExecutionMode executionMode;
    private boolean isProxy;
    @Nullable
    private String defaultFilters;
    @Nullable
    List<String> enumSubclasses;

    MockedClassModifier(@Nullable ClassLoader classLoader, @Nonnull ClassReader classReader, @Nullable MockedType typeMetadata) {
        super(classReader);
        this.mockedType = typeMetadata;
        this.setUseClassLoadingBridge(classLoader);
        this.executionMode = typeMetadata != null && typeMetadata.injectable ? ExecutionMode.PerInstance : ExecutionMode.Regular;
    }

    void useDynamicMocking() {
        this.executionMode = ExecutionMode.Partial;
    }

    void setClassNameForCapturedInstanceMethods(@Nonnull String internalClassName) {
        this.baseClassNameForCapturedInstanceMethods = internalClassName;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        this.validateMockingOfJREClass(name);
        super.visit(version, access, name, additionalInfo);
        this.isProxy = "java/lang/reflect/Proxy".equals(additionalInfo.superName);
        if (this.isProxy) {
            this.className = additionalInfo.interfaces[0];
        } else {
            this.className = name;
            this.defaultFilters = FILTERS.get(name);
        }
        if (this.baseClassNameForCapturedInstanceMethods != null) {
            this.className = this.baseClassNameForCapturedInstanceMethods;
        }
    }

    private void validateMockingOfJREClass(@Nonnull String internalName) {
        if (internalName.startsWith("java/")) {
            String modifyingClassName;
            MockingFilters.validateAsMockable(internalName);
            if (this.executionMode == ExecutionMode.Regular && this.mockedType != null && MockedClassModifier.isFullMockingDisallowed(internalName) && (modifyingClassName = internalName.replace('/', '.')).equals(this.mockedType.getClassType().getName())) {
                throw new IllegalArgumentException("Class " + modifyingClassName + " cannot be @Mocked fully; instead, use @Injectable or partial mocking");
            }
        }
    }

    private static boolean isFullMockingDisallowed(@Nonnull String classDesc) {
        return classDesc.startsWith("java/io/") && ("java/io/FileOutputStream".equals(classDesc) || "java/io/FileInputStream".equals(classDesc) || "java/io/FileWriter".equals(classDesc) || "java/io/PrintWriter java/io/Writer java/io/DataInputStream".contains(classDesc));
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.cw.visitInnerClass(name, outerName, innerName, access);
        if (access == 16400 || access == 16392) {
            if (this.enumSubclasses == null) {
                this.enumSubclasses = new ArrayList<String>();
            }
            this.enumSubclasses.add(name);
        }
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if ((access & 0x1402) != 0) {
            return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
        }
        this.methodSignature = signature;
        if ("<init>".equals(name)) {
            if (this.isConstructorNotAllowedByMockingFilters(name)) {
                return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
            }
        } else {
            if (this.stubOutFinalizeMethod(access, name, desc)) {
                return null;
            }
            if (this.isMethodNotToBeMocked(access, name, desc) || this.isMethodNotAllowedByMockingFilters(access, name)) {
                return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
            }
        }
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        if (Modifier.isNative(this.methodAccess)) {
            this.generateEmptyImplementation(this.methodDesc);
            return this.methodAnnotationsVisitor;
        }
        return this.copyOriginalImplementationWithInjectedInterceptionCode();
    }

    @Nonnull
    private MethodVisitor unmodifiedBytecode(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        return this.cw.visitMethod(access, name, desc, signature, exceptions);
    }

    private boolean isConstructorNotAllowedByMockingFilters(@Nonnull String name) {
        return this.isProxy || this.executionMode != ExecutionMode.Regular || this.isUnmockableInvocation(name);
    }

    private boolean isUnmockableInvocation(@Nonnull String name) {
        if (this.defaultFilters == null) {
            return false;
        }
        int i = this.defaultFilters.indexOf(name);
        return i > -1 && this.defaultFilters.charAt(i + name.length()) == ' ';
    }

    private boolean isMethodNotToBeMocked(int access, @Nonnull String name, @Nonnull String desc) {
        return "<clinit>".equals(name) || Modifier.isNative(access) && (NATIVE_UNSUPPORTED || (access & 5) == 0) || (this.isProxy || this.executionMode == ExecutionMode.Partial) && (ObjectMethods.isMethodFromObject(name, desc) || "annotationType".equals(name) && "()Ljava/lang/Class;".equals(desc));
    }

    private boolean stubOutFinalizeMethod(int access, @Nonnull String name, @Nonnull String desc) {
        if ("finalize".equals(name) && "()V".equals(desc)) {
            this.startModifiedMethodVersion(access, name, desc, null, null);
            this.generateEmptyImplementation();
            return true;
        }
        return false;
    }

    private boolean isMethodNotAllowedByMockingFilters(int access, @Nonnull String name) {
        return this.baseClassNameForCapturedInstanceMethods != null && (access & 8) != 0 || this.executionMode.isMethodToBeIgnored(access) || this.isUnmockableInvocation(name);
    }

    @Override
    protected void generateInterceptionCode() {
        if (this.useClassLoadingBridge) {
            this.generateCallToHandlerThroughMockingBridge();
        } else {
            this.generateDirectCallToHandler(this.className, this.methodAccess, this.methodName, this.methodDesc, this.methodSignature, this.executionMode);
        }
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation();
    }

    private void generateCallToHandlerThroughMockingBridge() {
        this.generateCodeToObtainInstanceOfClassLoadingBridge(MockedBridge.MB);
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        JavaType[] argTypes = JavaType.getArgumentTypes(this.methodDesc);
        this.generateCodeToCreateArrayOfObject(6 + argTypes.length);
        int i = 0;
        this.generateCodeToFillArrayElement(i, this.methodAccess);
        this.generateCodeToFillArrayElement(++i, this.className);
        this.generateCodeToFillArrayElement(++i, this.methodName);
        this.generateCodeToFillArrayElement(++i, this.methodDesc);
        this.generateCodeToFillArrayElement(++i, this.methodSignature);
        this.generateCodeToFillArrayElement(++i, this.executionMode.ordinal());
        this.generateCodeToFillArrayWithParameterValues(argTypes, ++i, isStatic ? 0 : 1);
        this.generateCallToInvocationHandler();
    }

    private void generateDecisionBetweenReturningOrContinuingToRealImplementation() {
        Label startOfRealImplementation = new Label();
        this.mw.visitInsn(89);
        this.mw.visitLdcInsn(VOID_TYPE);
        this.mw.visitJumpInsn(165, startOfRealImplementation);
        this.generateReturnWithObjectAtTopOfTheStack(this.methodDesc);
        this.mw.visitLabel(startOfRealImplementation);
        this.mw.visitInsn(87);
    }

    static {
        FILTERS.put("java/lang/Object", "<init> clone getClass hashCode wait notify notifyAll ");
        FILTERS.put("java/io/File", "compareTo equals getName getPath hashCode toString ");
        FILTERS.put("java/util/logging/Logger", "<init> getName ");
        FILTERS.put("java/util/jar/JarEntry", "<init> ");
    }
}

