/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.internal.expectations.MockingFilters;
import mockit.internal.expectations.mocking.BaseTypeRedefinition;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedClassModifier;
import mockit.internal.state.TestRun;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.GeneratedClasses;

public final class PartialMocking
extends BaseTypeRedefinition {
    @Nonnull
    public final List<Object> targetInstances = new ArrayList<Object>(2);
    @Nonnull
    private final Map<Class<?>, byte[]> modifiedClassfiles = new HashMap();

    public void redefineTypes(@Nonnull Object[] instancesToBePartiallyMocked) {
        for (Object instance : instancesToBePartiallyMocked) {
            this.redefineClassHierarchy(instance);
        }
        if (!this.modifiedClassfiles.isEmpty()) {
            TestRun.mockFixture().redefineMethods(this.modifiedClassfiles);
            this.modifiedClassfiles.clear();
        }
    }

    private void redefineClassHierarchy(@Nonnull Object mockInstance) {
        if (mockInstance instanceof Class) {
            throw new IllegalArgumentException("Invalid Class argument for partial mocking (use a MockUp instead): " + mockInstance);
        }
        this.targetClass = GeneratedClasses.getMockedClass(mockInstance);
        this.applyPartialMockingToGivenInstance(mockInstance);
        InstanceFactory instanceFactory = this.createInstanceFactory(this.targetClass);
        instanceFactory.lastInstance = mockInstance;
        TestRun.mockFixture().registerInstanceFactoryForMockedType(this.targetClass, instanceFactory);
        TestRun.getExecutingTest().getCascadingTypes().add(false, this.targetClass);
    }

    private void applyPartialMockingToGivenInstance(@Nonnull Object instance) {
        this.validateTargetClassType();
        this.redefineMethodsAndConstructorsInTargetType();
        this.targetInstances.add(instance);
    }

    private void validateTargetClassType() {
        if (this.targetClass.isInterface() || this.targetClass.isAnnotation() || this.targetClass.isArray() || this.targetClass.isPrimitive() || this.targetClass.isSynthetic() || MockingFilters.isSubclassOfUnmockable(this.targetClass) || AutoBoxing.isWrapperOfPrimitiveType(this.targetClass) || GeneratedClasses.isGeneratedImplementationClass(this.targetClass)) {
            throw new IllegalArgumentException("Invalid type for partial mocking: " + this.targetClass);
        }
    }

    @Override
    void configureClassModifier(@Nonnull MockedClassModifier modifier) {
        modifier.useDynamicMocking();
    }

    @Override
    void applyClassRedefinition(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        this.modifiedClassfiles.put(realClass, modifiedClass);
    }
}

