/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.state;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.types.JavaType;
import mockit.internal.expectations.MockingFilters;
import mockit.internal.expectations.mocking.CascadingTypeRedefinition;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.state.CascadingTypes;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.reflection.RealMethodOrConstructor;
import mockit.internal.state.TestRun;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.Utilities;

public final class MockedTypeCascade {
    @Nonnull
    private static final CascadingTypes CASCADING_TYPES = TestRun.getExecutingTest().getCascadingTypes();
    private static final int PUBLIC_INTERFACE = 513;
    final boolean fromMockField;
    @Nonnull
    private final Type mockedType;
    @Nonnull
    final String mockedTypeDesc;
    @Nullable
    Class<?> mockedClass;
    @Nullable
    private GenericTypeReflection genericReflection;
    @Nonnull
    private final Map<String, Type> cascadedTypesAndMocks;
    @Nonnull
    private final List<Object> cascadingInstances;

    MockedTypeCascade(boolean fromMockField, @Nonnull Type mockedType, @Nonnull String mockedTypeDesc) {
        this.fromMockField = fromMockField;
        this.mockedType = mockedType;
        this.mockedTypeDesc = mockedTypeDesc;
        this.cascadedTypesAndMocks = new ConcurrentHashMap<String, Type>(4);
        this.cascadingInstances = Collections.synchronizedList(new ArrayList());
    }

    @Nullable
    public static Object getMock(@Nonnull String mockedTypeDesc, @Nonnull String mockedMethodNameAndDesc, @Nullable Object mockInstance, @Nonnull String returnTypeDesc, @Nonnull Class<?> returnType) {
        MockedTypeCascade cascade = CASCADING_TYPES.getCascade(mockedTypeDesc, mockInstance);
        if (cascade == null) {
            return null;
        }
        String cascadedReturnTypeDesc = MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnTypeDesc);
        if (cascadedReturnTypeDesc == null) {
            return null;
        }
        return cascade.getCascadedInstance(mockedMethodNameAndDesc, cascadedReturnTypeDesc, returnType);
    }

    @Nullable
    public static Object getMock(@Nonnull String mockedTypeDesc, @Nonnull String mockedMethodNameAndDesc, @Nullable Object mockInstance, @Nonnull String returnTypeDesc, @Nullable String genericSignature) {
        char typeCode = returnTypeDesc.charAt(0);
        if (typeCode != 'L') {
            return null;
        }
        MockedTypeCascade cascade = CASCADING_TYPES.getCascade(mockedTypeDesc, mockInstance);
        if (cascade == null) {
            return null;
        }
        String resolvedReturnTypeDesc = null;
        if (genericSignature != null) {
            resolvedReturnTypeDesc = cascade.getGenericReturnType(mockedTypeDesc, genericSignature);
        }
        if (resolvedReturnTypeDesc == null) {
            resolvedReturnTypeDesc = MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnTypeDesc);
            if (resolvedReturnTypeDesc == null) {
                return null;
            }
        } else if (resolvedReturnTypeDesc.charAt(0) == '[') {
            return DefaultValues.computeForArrayType(resolvedReturnTypeDesc);
        }
        return cascade.getCascadedInstance(mockedMethodNameAndDesc, resolvedReturnTypeDesc, mockInstance);
    }

    @Nullable
    private String getGenericReturnType(@Nonnull String ownerTypeDesc, @Nonnull String genericSignature) {
        String resolvedSignature = this.getGenericReflection().resolveSignature(ownerTypeDesc, genericSignature);
        String returnTypeDesc = resolvedSignature.substring(resolvedSignature.indexOf(41) + 1);
        if (returnTypeDesc.charAt(0) == '[') {
            return returnTypeDesc;
        }
        String returnTypeName = returnTypeDesc.substring(1, returnTypeDesc.length() - 1);
        return MockedTypeCascade.isTypeSupportedForCascading(returnTypeName) ? returnTypeName : null;
    }

    @Nonnull
    private synchronized GenericTypeReflection getGenericReflection() {
        GenericTypeReflection reflection = this.genericReflection;
        if (reflection == null) {
            Class<?> ownerClass = this.getClassWithCalledMethod();
            this.genericReflection = reflection = new GenericTypeReflection(ownerClass, this.mockedType);
        }
        return reflection;
    }

    private static boolean isReturnTypeNotSupportedForCascading(@Nonnull Class<?> returnType) {
        return MockingFilters.isSubclassOfUnmockable(returnType) || !MockedTypeCascade.isTypeSupportedForCascading(JavaType.getInternalName(returnType));
    }

    private static boolean isTypeSupportedForCascading(@Nonnull String typeName) {
        if (typeName.contains("/Process") || typeName.endsWith("/Runnable")) {
            return true;
        }
        return !(typeName.startsWith("java/lang/") && !typeName.contains("management") || typeName.startsWith("java/math/") || typeName.startsWith("java/util/") && !typeName.endsWith("/Date") && !typeName.endsWith("/Callable") && !typeName.endsWith("Future") && !typeName.contains("logging") || "java/time/Duration".equals(typeName));
    }

    @Nullable
    private static String getReturnTypeIfCascadingSupportedForIt(@Nonnull String typeDesc) {
        String typeName = typeDesc.substring(1, typeDesc.length() - 1);
        return MockedTypeCascade.isTypeSupportedForCascading(typeName) ? typeName : null;
    }

    @Nullable
    private Object getCascadedInstance(@Nonnull String methodNameAndDesc, @Nonnull String returnTypeInternalName, @Nonnull Class<?> returnClass) {
        MockedTypeCascade nextLevel = this;
        if (!this.cascadedTypesAndMocks.containsKey(returnTypeInternalName)) {
            this.cascadedTypesAndMocks.put(returnTypeInternalName, returnClass);
            nextLevel = CASCADING_TYPES.add(returnTypeInternalName, false, returnClass);
        }
        return nextLevel.createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(methodNameAndDesc, returnClass);
    }

    @Nullable
    private Object getCascadedInstance(@Nonnull String methodNameAndDesc, @Nonnull String returnTypeInternalName, @Nullable Object mockInstance) {
        MockedTypeCascade nextLevel = this;
        Type returnType = this.cascadedTypesAndMocks.get(returnTypeInternalName);
        if (returnType == null) {
            Class<?> cascadingClass = this.getClassWithCalledMethod();
            Type genericReturnType = this.getGenericReturnType(cascadingClass, methodNameAndDesc);
            if (genericReturnType == null) {
                return null;
            }
            Class<?> resolvedReturnType = Utilities.getClassType(genericReturnType);
            if (resolvedReturnType.isAssignableFrom(cascadingClass)) {
                if (mockInstance != null) {
                    return mockInstance;
                }
                returnType = this.mockedType;
            } else {
                if (MockedTypeCascade.nonPublicTypeReturnedFromPublicInterface(cascadingClass, resolvedReturnType) || MockedTypeCascade.isReturnTypeNotSupportedForCascading(resolvedReturnType)) {
                    return null;
                }
                Object defaultReturnValue = DefaultValues.computeForType(resolvedReturnType);
                if (defaultReturnValue != null) {
                    return defaultReturnValue;
                }
                this.cascadedTypesAndMocks.put(returnTypeInternalName, genericReturnType);
                nextLevel = CASCADING_TYPES.add(returnTypeInternalName, false, genericReturnType);
                returnType = genericReturnType;
            }
        } else {
            nextLevel = CASCADING_TYPES.getCascade(returnType);
        }
        return nextLevel.createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(methodNameAndDesc, returnType);
    }

    private static boolean nonPublicTypeReturnedFromPublicInterface(@Nonnull Class<?> cascadingClass, @Nonnull Class<?> resolvedReturnType) {
        return cascadingClass.isInterface() && !Modifier.isPublic(resolvedReturnType.getModifiers()) && cascadingClass.getClassLoader() != null && (cascadingClass.getModifiers() & 0x201) != 0 && !resolvedReturnType.isMemberClass();
    }

    @Nonnull
    private Class<?> getClassWithCalledMethod() {
        if (this.mockedClass != null) {
            return this.mockedClass;
        }
        if (this.mockedType instanceof Class) {
            return (Class)this.mockedType;
        }
        return (Class)((ParameterizedType)this.mockedType).getRawType();
    }

    @Nullable
    private Type getGenericReturnType(@Nonnull Class<?> cascadingClass, @Nonnull String methodNameAndDesc) {
        RealMethodOrConstructor realMethod;
        try {
            realMethod = new RealMethodOrConstructor(cascadingClass, methodNameAndDesc);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        Method cascadingMethod = (Method)realMethod.getMember();
        Type genericReturnType = cascadingMethod.getGenericReturnType();
        if (genericReturnType instanceof TypeVariable) {
            genericReturnType = this.getGenericReflection().resolveTypeVariable((TypeVariable)genericReturnType);
        }
        return genericReturnType == Object.class ? null : genericReturnType;
    }

    @Nullable
    private Object createNewCascadedInstanceOrUseNonCascadedOneIfAvailable(@Nonnull String methodNameAndDesc, @Nonnull Type mockedReturnType) {
        InstanceFactory instanceFactory = TestRun.mockFixture().findInstanceFactory(mockedReturnType);
        if (instanceFactory == null) {
            String methodName = methodNameAndDesc.substring(0, methodNameAndDesc.indexOf(40));
            CascadingTypeRedefinition typeRedefinition = new CascadingTypeRedefinition(methodName, mockedReturnType);
            instanceFactory = typeRedefinition.redefineType();
            if (instanceFactory == null) {
                return null;
            }
        } else {
            Object lastInstance = instanceFactory.getLastInstance();
            if (lastInstance != null) {
                return lastInstance;
            }
        }
        Object cascadedInstance = instanceFactory.create();
        instanceFactory.clearLastInstance();
        this.addInstance(cascadedInstance);
        TestRun.getExecutingTest().addInjectableMock(cascadedInstance);
        return cascadedInstance;
    }

    void discardCascadedMocks() {
        this.cascadedTypesAndMocks.clear();
        this.cascadingInstances.clear();
    }

    void addInstance(@Nonnull Object cascadingInstance) {
        this.cascadingInstances.add(cascadingInstance);
    }

    boolean hasInstance(@Nonnull Object cascadingInstance) {
        return Utilities.containsReference(this.cascadingInstances, cascadingInstance);
    }
}

