/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.asm.classes.ClassReader;
import mockit.internal.BaseClassModifier;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.faking.FakeClassSetup;
import mockit.internal.faking.FakedImplementationClass;
import mockit.internal.util.Utilities;

public final class CaptureOfFakedImplementations
extends CaptureOfImplementations<Void> {
    private final FakeClassSetup fakeClassSetup;

    public CaptureOfFakedImplementations(@Nonnull MockUp<?> fake, @Nonnull Type baseType) {
        Class<?> baseClassType = Utilities.getClassType(baseType);
        this.fakeClassSetup = new FakeClassSetup(baseClassType, baseType, fake, null);
    }

    @Override
    @Nonnull
    protected BaseClassModifier createModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, Void typeMetadata) {
        return this.fakeClassSetup.createClassModifier(cr);
    }

    @Override
    protected void redefineClass(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        this.fakeClassSetup.applyClassModifications(realClass, modifiedClass);
    }

    @Nullable
    public <T> Class<T> apply() {
        Class<?> baseType;
        Class<Object> baseClassType = baseType = this.fakeClassSetup.realClass;
        Class fakedClass = null;
        if (baseType.isInterface()) {
            fakedClass = new FakedImplementationClass(this.fakeClassSetup.fake).createImplementation(baseType);
            baseClassType = fakedClass;
        }
        if (baseClassType != Object.class) {
            this.redefineClass(baseClassType, baseType, null);
        }
        this.makeSureAllSubtypesAreModified(baseType, false, null);
        return fakedClass;
    }
}

