/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.asm.classes.ClassReader;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.faking.FakeClasses;
import mockit.internal.faking.FakeMethodCollector;
import mockit.internal.faking.FakeMethods;
import mockit.internal.faking.FakedClassModifier;
import mockit.internal.startup.Startup;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.state.TestRun;

public final class FakeClassSetup {
    @Nonnull
    final Class<?> realClass;
    @Nullable
    private ClassReader rcReader;
    @Nonnull
    private final FakeMethods fakeMethods;
    @Nonnull
    final MockUp<?> fake;
    private final boolean forStartupFake;

    public FakeClassSetup(@Nonnull Class<?> realClass, @Nonnull Class<?> classToFake, @Nullable Type fakedType, @Nonnull MockUp<?> fake) {
        this(realClass, classToFake, fakedType, fake, null);
    }

    FakeClassSetup(@Nonnull Class<?> realClass, @Nullable Type fakedType, @Nonnull MockUp<?> fake, @Nullable byte[] realClassCode) {
        this(realClass, realClass, fakedType, fake, realClassCode);
    }

    FakeClassSetup(@Nonnull Class<?> realClass, @Nonnull Class<?> classToFake, @Nullable Type fakedType, @Nonnull MockUp<?> fake, @Nullable byte[] realClassCode) {
        this.realClass = classToFake;
        this.fake = fake;
        this.forStartupFake = Startup.initializing;
        this.rcReader = realClassCode == null ? null : new ClassReader(realClassCode);
        this.fakeMethods = new FakeMethods(realClass, fakedType);
        this.collectFakeMethods();
        this.registerFakeClassAndItsStates();
    }

    private void collectFakeMethods() {
        Class<?> fakeClass = this.fake.getClass();
        new FakeMethodCollector(this.fakeMethods).collectFakeMethods(fakeClass);
    }

    private void registerFakeClassAndItsStates() {
        this.fakeMethods.registerFakeStates(this.fake, this.forStartupFake);
        FakeClasses fakeClasses = TestRun.getFakeClasses();
        if (this.forStartupFake) {
            fakeClasses.addFake(this.fakeMethods.getFakeClassInternalName(), this.fake);
        } else {
            fakeClasses.addFake(this.fake);
        }
    }

    void redefineMethodsInGeneratedClass() {
        byte[] modifiedClassFile = this.modifyRealClass(this.realClass);
        if (modifiedClassFile != null) {
            this.applyClassModifications(this.realClass, modifiedClassFile);
        }
    }

    public void redefineMethods() {
        Class<?> classToModify = this.realClass;
        while (classToModify != null && this.fakeMethods.hasUnusedFakes()) {
            Class<?> superClass;
            byte[] modifiedClassFile = this.modifyRealClass(classToModify);
            if (modifiedClassFile != null) {
                this.applyClassModifications(classToModify, modifiedClassFile);
            }
            classToModify = (superClass = classToModify.getSuperclass()) == Object.class || superClass == Proxy.class ? null : superClass;
            this.rcReader = null;
        }
    }

    @Nullable
    private byte[] modifyRealClass(@Nonnull Class<?> classToModify) {
        if (this.rcReader == null) {
            this.rcReader = ClassFile.createReaderFromLastRedefinitionIfAny(classToModify);
        }
        FakedClassModifier modifier = new FakedClassModifier(this.rcReader, classToModify, this.fake, this.fakeMethods);
        this.rcReader.accept(modifier);
        return modifier.wasModified() ? modifier.toByteArray() : null;
    }

    @Nonnull
    BaseClassModifier createClassModifier(@Nonnull ClassReader cr) {
        return new FakedClassModifier(cr, this.realClass, this.fake, this.fakeMethods);
    }

    void applyClassModifications(@Nonnull Class<?> classToModify, @Nonnull byte[] modifiedClassFile) {
        ClassDefinition classDef = new ClassDefinition(classToModify, modifiedClassFile);
        Startup.redefineMethods(classDef);
        if (this.forStartupFake) {
            CachedClassfiles.addClassfile(classToModify, modifiedClassFile);
        } else {
            String fakeClassDesc = this.fakeMethods.getFakeClassInternalName();
            TestRun.mockFixture().addRedefinedClass(fakeClassDesc, classDef);
        }
    }
}

