/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.internal.faking.FakeStates;
import mockit.internal.util.ClassLoad;

public final class FakeClasses {
    private static final Field INVOKED_INSTANCE_FIELD;
    private static final Method ON_TEAR_DOWN_METHOD;
    @Nonnull
    private final Map<String, MockUp<?>> startupMocks = new IdentityHashMap(8);
    @Nonnull
    private final Map<Class<?>, MockUpInstances> mockupClassesToMockupInstances = new IdentityHashMap();
    @Nonnull
    private final Map<Object, MockUp<?>> mockedToMockupInstances = new IdentityHashMap();
    @Nonnull
    public final FakeStates fakeStates = new FakeStates();

    private static void notifyOfTearDown(@Nonnull MockUp<?> mockUp) {
        try {
            ON_TEAR_DOWN_METHOD.invoke(mockUp, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
    }

    public void addFake(@Nonnull String mockClassDesc, @Nonnull MockUp<?> mockUp) {
        this.startupMocks.put(mockClassDesc, mockUp);
    }

    public void addFake(@Nonnull MockUp<?> mockUp) {
        Class<?> mockUpClass = mockUp.getClass();
        MockUpInstances newData = new MockUpInstances(mockUp);
        this.mockupClassesToMockupInstances.put(mockUpClass, newData);
    }

    public void addFake(@Nonnull MockUp<?> mockUp, @Nonnull Object mockedInstance) {
        MockUp<?> previousMockup = this.mockedToMockupInstances.put(mockedInstance, mockUp);
        assert (previousMockup == null);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUp.getClass());
        mockUpInstances.hasMockupsForSingleInstances = true;
    }

    @Nullable
    public MockUp<?> getFake(@Nonnull String mockUpClassDesc, @Nullable Object mockedInstance) {
        MockUp<?> mockUpForSingleInstance;
        if (mockedInstance != null && (mockUpForSingleInstance = this.mockedToMockupInstances.get(mockedInstance)) != null) {
            return mockUpForSingleInstance;
        }
        MockUp<?> startupMock = this.startupMocks.get(mockUpClassDesc);
        if (startupMock != null) {
            return startupMock;
        }
        Class mockUpClass = ClassLoad.loadByInternalName(mockUpClassDesc);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        Class<Void> invokedInstance = mockedInstance;
        if (mockedInstance == null) {
            invokedInstance = Void.class;
        } else if (mockUpInstances.hasMockUpsForSingleInstances()) {
            return null;
        }
        try {
            INVOKED_INSTANCE_FIELD.set(mockUpInstances.initialMockUp, invokedInstance);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return mockUpInstances.initialMockUp;
    }

    @Nullable
    public MockUpInstances findPreviouslyAppliedMockUps(@Nonnull MockUp<?> newMockUp) {
        Class<?> mockUpClass = newMockUp.getClass();
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        if (mockUpInstances != null && mockUpInstances.hasMockupsForSingleInstances) {
            this.fakeStates.copyFakeStates(mockUpInstances.initialMockUp, newMockUp);
        }
        return mockUpInstances;
    }

    private void discardMockupInstances(@Nonnull Map<Object, MockUp<?>> previousMockInstances) {
        if (!previousMockInstances.isEmpty()) {
            this.mockedToMockupInstances.entrySet().retainAll(previousMockInstances.entrySet());
        } else if (!this.mockedToMockupInstances.isEmpty()) {
            this.mockedToMockupInstances.clear();
        }
    }

    private void discardMockupInstancesExceptPreviousOnes(@Nonnull Map<Class<?>, Boolean> previousMockupClasses) {
        this.updatePreviousMockups(previousMockupClasses);
        for (Map.Entry<Class<?>, MockUpInstances> mockupClassAndInstances : this.mockupClassesToMockupInstances.entrySet()) {
            Class<?> mockupClass = mockupClassAndInstances.getKey();
            if (previousMockupClasses.containsKey(mockupClass)) continue;
            MockUpInstances mockUpInstances = mockupClassAndInstances.getValue();
            mockUpInstances.notifyMockUpOfTearDown();
        }
        this.mockupClassesToMockupInstances.keySet().retainAll(previousMockupClasses.keySet());
    }

    private void updatePreviousMockups(@Nonnull Map<Class<?>, Boolean> previousMockupClasses) {
        for (Map.Entry<Class<?>, Boolean> mockupClassAndData : previousMockupClasses.entrySet()) {
            Class<?> mockupClass = mockupClassAndData.getKey();
            MockUpInstances mockUpData = this.mockupClassesToMockupInstances.get(mockupClass);
            mockUpData.hasMockupsForSingleInstances = mockupClassAndData.getValue();
        }
    }

    private void discardAllMockupInstances() {
        if (!this.mockupClassesToMockupInstances.isEmpty()) {
            for (MockUpInstances mockUpInstances : this.mockupClassesToMockupInstances.values()) {
                mockUpInstances.notifyMockUpOfTearDown();
            }
            this.mockupClassesToMockupInstances.clear();
        }
    }

    public void discardStartupFakes() {
        for (MockUp<?> startupMockup : this.startupMocks.values()) {
            FakeClasses.notifyOfTearDown(startupMockup);
        }
    }

    static {
        try {
            INVOKED_INSTANCE_FIELD = MockUp.class.getDeclaredField("invokedInstance");
            INVOKED_INSTANCE_FIELD.setAccessible(true);
            ON_TEAR_DOWN_METHOD = MockUp.class.getDeclaredMethod("onTearDown", new Class[0]);
            ON_TEAR_DOWN_METHOD.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public final class SavePoint {
        @Nonnull
        private final Map<Object, MockUp<?>> previousMockInstances;
        @Nonnull
        private final Map<Class<?>, Boolean> previousMockupClasses;

        public SavePoint() {
            this.previousMockInstances = new IdentityHashMap(FakeClasses.this.mockedToMockupInstances);
            this.previousMockupClasses = new IdentityHashMap();
            for (Map.Entry<Class<?>, MockUpInstances> mockUpClassAndData : FakeClasses.this.mockupClassesToMockupInstances.entrySet()) {
                Class<?> mockUpClass = mockUpClassAndData.getKey();
                MockUpInstances mockUpData = mockUpClassAndData.getValue();
                this.previousMockupClasses.put(mockUpClass, mockUpData.hasMockupsForSingleInstances);
            }
        }

        public void rollback() {
            FakeClasses.this.discardMockupInstances(this.previousMockInstances);
            if (!this.previousMockupClasses.isEmpty()) {
                FakeClasses.this.discardMockupInstancesExceptPreviousOnes(this.previousMockupClasses);
            } else {
                FakeClasses.this.discardAllMockupInstances();
            }
        }
    }

    public static final class MockUpInstances {
        @Nonnull
        public final MockUp<?> initialMockUp;
        boolean hasMockupsForSingleInstances;

        MockUpInstances(@Nonnull MockUp<?> initialMockUp) {
            this.initialMockUp = initialMockUp;
            this.hasMockupsForSingleInstances = false;
        }

        public boolean hasMockUpsForSingleInstances() {
            return this.hasMockupsForSingleInstances;
        }

        void notifyMockUpOfTearDown() {
            FakeClasses.notifyOfTearDown(this.initialMockUp);
        }
    }
}

