/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.BaseInvocation;
import mockit.internal.faking.FakeState;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class FakeInvocation
extends BaseInvocation {
    @Nonnull
    private final FakeState fakeState;
    @Nonnull
    private final String fakedClassDesc;
    @Nonnull
    private final String fakedMethodName;
    @Nonnull
    private final String fakedMethodDesc;
    boolean proceeding;

    @Nonnull
    public static FakeInvocation create(@Nullable Object invokedInstance, @Nullable Object[] invokedArguments, @Nonnull String fakeClassDesc, @Nonnegative int fakeStateIndex, @Nonnull String fakedClassDesc, @Nonnull String fakedMethodName, @Nonnull String fakedMethodDesc) {
        Object fake = TestRun.getFake(fakeClassDesc, invokedInstance);
        assert (fake != null);
        FakeState fakeState = TestRun.getFakeStates().getFakeState(fake, fakeStateIndex);
        Object[] args = invokedArguments == null ? Utilities.NO_ARGS : invokedArguments;
        return new FakeInvocation(invokedInstance, args, fakeState, fakedClassDesc, fakedMethodName, fakedMethodDesc);
    }

    FakeInvocation(@Nullable Object invokedInstance, @Nonnull Object[] invokedArguments, @Nonnull FakeState fakeState, @Nonnull String fakedClassDesc, @Nonnull String fakedMethodName, @Nonnull String fakedMethodDesc) {
        super(invokedInstance, invokedArguments, fakeState.getTimesInvoked());
        this.fakeState = fakeState;
        this.fakedClassDesc = fakedClassDesc;
        this.fakedMethodName = fakedMethodName;
        this.fakedMethodDesc = fakedMethodDesc;
    }

    @Override
    @Nonnull
    protected Member findRealMember() {
        Object invokedInstance = this.getInvokedInstance();
        if (invokedInstance != null) {
            Class<?> mockedClass = invokedInstance.getClass();
            return this.fakeState.getRealMethodOrConstructor(mockedClass, this.fakedMethodName, this.fakedMethodDesc);
        }
        return this.fakeState.getRealMethodOrConstructor(this.fakedClassDesc, this.fakedMethodName, this.fakedMethodDesc);
    }

    public boolean shouldProceedIntoConstructor() {
        if (this.proceeding && this.getInvokedMember() instanceof Constructor) {
            this.fakeState.clearProceedIndicator();
            return true;
        }
        return false;
    }

    @Override
    public void prepareToProceed() {
        this.fakeState.prepareToProceed(this);
        this.proceeding = true;
    }

    public void prepareToProceedFromNonRecursiveMock() {
        this.fakeState.prepareToProceedFromNonRecursiveFake(this);
        this.proceeding = true;
    }

    @Override
    public void cleanUpAfterProceed() {
        this.fakeState.clearProceedIndicator();
    }
}

