/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassLoadingBridge;
import mockit.internal.faking.FakeState;
import mockit.internal.faking.FakeStates;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.TypeDescriptor;
import mockit.internal.util.Utilities;

final class FakeMethods {
    @Nonnull
    private final Class<?> realClass;
    private final boolean targetTypeIsAClass;
    private final boolean reentrantRealClass;
    @Nonnull
    private final List<FakeMethod> methods;
    @Nullable
    private FakeMethod adviceMethod;
    @Nonnull
    private final GenericTypeReflection typeParametersToTypeArguments;
    @Nonnull
    private String fakeClassInternalName;
    @Nullable
    private List<FakeState> fakeStates;

    FakeMethods(@Nonnull Class<?> realClass, @Nullable Type targetType) {
        Class<?> targetClass;
        this.realClass = realClass;
        this.targetTypeIsAClass = targetType == null || realClass == targetType ? true : !(targetClass = Utilities.getClassType(targetType)).isInterface();
        this.reentrantRealClass = this.targetTypeIsAClass && ClassLoadingBridge.instanceOfClassThatParticipatesInClassLoading(realClass);
        this.methods = new ArrayList<FakeMethod>();
        this.typeParametersToTypeArguments = new GenericTypeReflection(realClass, targetType);
        this.fakeClassInternalName = "";
    }

    @Nonnull
    Class<?> getRealClass() {
        return this.realClass;
    }

    @Nullable
    FakeMethod addMethod(boolean fromSuperClass, int access, @Nonnull String name, @Nonnull String desc) {
        if (fromSuperClass && this.isMethodAlreadyAdded(name, desc)) {
            return null;
        }
        FakeMethod fakeMethod = new FakeMethod(access, name, desc);
        if (fakeMethod.isAdvice) {
            this.adviceMethod = fakeMethod;
        } else {
            this.methods.add(fakeMethod);
        }
        return fakeMethod;
    }

    private boolean isMethodAlreadyAdded(@Nonnull String name, @Nonnull String desc) {
        int p = desc.lastIndexOf(41);
        String params = desc.substring(0, p + 1);
        for (FakeMethod fakeMethod : this.methods) {
            if (!fakeMethod.name.equals(name) || !fakeMethod.desc.startsWith(params)) continue;
            return true;
        }
        return false;
    }

    void addFakeState(@Nonnull FakeState fakeState) {
        if (this.fakeStates == null) {
            this.fakeStates = new ArrayList<FakeState>(4);
        }
        fakeState.fakeMethod.indexForFakeState = this.fakeStates.size();
        this.fakeStates.add(fakeState);
    }

    @Nullable
    FakeMethod findMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature) {
        FakeMethod fakeMethodMatchingByNameOnly = null;
        for (FakeMethod fakeMethod : this.methods) {
            if (fakeMethod.isMatch(access, name, desc, signature)) {
                if (Modifier.isNative(access) && this.hasIntrinsicCandidateAnnotation(this.getRealClass(), name, desc)) {
                    throw new UnsupportedOperationException("Native methods annotated with IntrinsicCandidate cannot be mocked: " + this.getRealClass().getSimpleName() + "#" + name);
                }
                return fakeMethod;
            }
            if (!fakeMethod.isMatchByName(name)) continue;
            fakeMethodMatchingByNameOnly = fakeMethod;
        }
        if (fakeMethodMatchingByNameOnly != null) {
            return fakeMethodMatchingByNameOnly;
        }
        if (!(this.adviceMethod == null || Modifier.isNative(access) || FakeMethods.isConstructorOrClassInitialization(name) || ObjectMethods.isMethodFromObject(name, desc))) {
            return this.adviceMethod;
        }
        return null;
    }

    private boolean hasIntrinsicCandidateAnnotation(Class<?> clazz, String methodName, String methodDescriptor) {
        Class<?>[] parameterTypes = TypeDescriptor.getParameterTypes(methodDescriptor);
        try {
            Annotation[] annotations;
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            for (Annotation annotation : annotations = method.getAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName();
                if (!annotationName.contains("IntrinsicCandidate")) continue;
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return false;
    }

    private static boolean isConstructorOrClassInitialization(@Nonnull String memberName) {
        return "$init".equals(memberName) || "$clinit".equals(memberName);
    }

    @Nonnull
    String getFakeClassInternalName() {
        return this.fakeClassInternalName;
    }

    void setFakeClassInternalName(@Nonnull String fakeClassInternalName) {
        this.fakeClassInternalName = fakeClassInternalName.intern();
    }

    boolean hasUnusedFakes() {
        if (this.adviceMethod != null) {
            return true;
        }
        for (FakeMethod method : this.methods) {
            if (method.hasMatchingRealMethod) continue;
            return true;
        }
        return false;
    }

    void registerFakeStates(@Nonnull Object fake, boolean forStartupFake) {
        if (this.fakeStates != null) {
            FakeStates allFakeStates = TestRun.getFakeStates();
            if (forStartupFake) {
                allFakeStates.addStartupFakeAndItsFakeStates(fake, this.fakeStates);
            } else {
                allFakeStates.addFakeAndItsFakeStates(fake, this.fakeStates);
            }
        }
    }

    final class FakeMethod {
        private final int access;
        @Nonnull
        final String name;
        @Nonnull
        final String desc;
        private final boolean isByNameOnly;
        final boolean isAdvice;
        @Nonnull
        final String fakeDescWithoutInvocationParameter;
        private boolean hasMatchingRealMethod;
        @Nullable
        private GenericTypeReflection.GenericSignature fakeSignature;
        private int indexForFakeState;
        private boolean nativeRealMethod;

        private FakeMethod(@Nonnull int access, @Nonnull String name, String desc) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            if (desc.contains("Lmockit/Invocation;")) {
                this.fakeDescWithoutInvocationParameter = "(" + desc.substring(20);
                this.isByNameOnly = name.charAt(0) != '$' && this.fakeDescWithoutInvocationParameter.startsWith("()");
                this.isAdvice = "$advice".equals(name) && "()Ljava/lang/Object;".equals(this.fakeDescWithoutInvocationParameter);
            } else {
                this.fakeDescWithoutInvocationParameter = desc;
                this.isByNameOnly = false;
                this.isAdvice = false;
            }
            this.hasMatchingRealMethod = false;
            this.indexForFakeState = -1;
        }

        boolean hasInvocationParameter() {
            return this.desc != this.fakeDescWithoutInvocationParameter;
        }

        boolean hasInvocationParameterOnly() {
            return this.isByNameOnly || this.isAdvice;
        }

        boolean isMatch(int realAccess, @Nonnull String realName, @Nonnull String realDesc, @Nullable String signature) {
            if (this.name.equals(realName) && this.hasMatchingParameters(realDesc, signature)) {
                this.hasMatchingRealMethod = true;
                this.nativeRealMethod = Modifier.isNative(realAccess);
                return true;
            }
            return false;
        }

        private boolean hasMatchingParameters(@Nonnull String methodDesc, @Nullable String signature) {
            boolean sameParametersIgnoringGenerics = this.fakeDescWithoutInvocationParameter.equals(methodDesc);
            if (sameParametersIgnoringGenerics || signature == null) {
                return sameParametersIgnoringGenerics;
            }
            if (this.fakeSignature == null) {
                this.fakeSignature = FakeMethods.this.typeParametersToTypeArguments.parseSignature(this.fakeDescWithoutInvocationParameter);
            }
            return this.fakeSignature.satisfiesGenericSignature(signature);
        }

        boolean isMatchByName(@Nonnull String realName) {
            return this.isByNameOnly && this.name.equals(realName);
        }

        @Nonnull
        Class<?> getRealClass() {
            return FakeMethods.this.realClass;
        }

        int getIndexForFakeState() {
            return this.indexForFakeState;
        }

        boolean isStatic() {
            return Modifier.isStatic(this.access);
        }

        boolean isPublic() {
            return Modifier.isPublic(this.access);
        }

        boolean isForGenericMethod() {
            return this.fakeSignature != null;
        }

        boolean isForNativeMethod() {
            return this.nativeRealMethod;
        }

        boolean requiresFakeState() {
            return this.hasInvocationParameter() || FakeMethods.this.reentrantRealClass;
        }

        boolean canBeReentered() {
            return FakeMethods.this.targetTypeIsAClass && !this.nativeRealMethod;
        }
    }
}

