/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.internal.classGeneration.ImplementationClass;
import mockit.internal.expectations.mocking.InterfaceImplementationGenerator;
import mockit.internal.faking.FakeClassSetup;
import mockit.internal.util.Utilities;

public final class FakedImplementationClass<T> {
    private static final ClassLoader THIS_CL = FakedImplementationClass.class.getClassLoader();
    @Nonnull
    private final MockUp<?> fakeInstance;
    @Nullable
    private ImplementationClass<T> implementationClass;
    private Class<T> generatedClass;

    public FakedImplementationClass(@Nonnull MockUp<?> fakeInstance) {
        this.fakeInstance = fakeInstance;
    }

    @Nonnull
    public Class<T> createImplementation(@Nonnull Class<T> interfaceToBeFaked, @Nullable Type typeToFake) {
        this.createImplementation(interfaceToBeFaked);
        byte[] generatedBytecode = this.implementationClass == null ? null : this.implementationClass.getGeneratedBytecode();
        FakeClassSetup fakeClassSetup = new FakeClassSetup(this.generatedClass, typeToFake, this.fakeInstance, generatedBytecode);
        fakeClassSetup.redefineMethodsInGeneratedClass();
        return this.generatedClass;
    }

    @Nonnull
    Class<T> createImplementation(@Nonnull Class<T> interfaceToBeFaked) {
        if (Modifier.isPublic(interfaceToBeFaked.getModifiers())) {
            this.generateImplementationForPublicInterface(interfaceToBeFaked);
        } else {
            this.generatedClass = Proxy.getProxyClass(interfaceToBeFaked.getClassLoader(), interfaceToBeFaked);
        }
        return this.generatedClass;
    }

    private void generateImplementationForPublicInterface(final @Nonnull Class<T> interfaceToBeFaked) {
        this.implementationClass = new ImplementationClass<T>(interfaceToBeFaked){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull ClassReader typeReader) {
                return new InterfaceImplementationGenerator(typeReader, interfaceToBeFaked, this.generatedClassName);
            }
        };
        this.generatedClass = this.implementationClass.generateClass();
    }

    @Nonnull
    public Class<T> createImplementation(@Nonnull Type[] interfacesToBeFaked) {
        Class[] interfacesToFake = new Class[interfacesToBeFaked.length];
        for (int i = 0; i < interfacesToFake.length; ++i) {
            interfacesToFake[i] = Utilities.getClassType(interfacesToBeFaked[i]);
        }
        this.generatedClass = Proxy.getProxyClass(THIS_CL, interfacesToFake);
        new FakeClassSetup(this.generatedClass, null, this.fakeInstance, null).redefineMethods();
        return this.generatedClass;
    }
}

