/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class InjectionProvider {
    public static final Object NULL = Void.class;
    @Nonnull
    protected final Type declaredType;
    @Nonnull
    protected final String name;
    @Nullable
    public InjectionProvider parent;

    protected InjectionProvider(@Nonnull Type declaredType, @Nonnull String name) {
        this.declaredType = declaredType;
        this.name = name;
    }

    @Nonnull
    public final Type getDeclaredType() {
        return this.declaredType;
    }

    @Nonnull
    public abstract Class<?> getClassOfDeclaredType();

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nonnull
    public Annotation[] getAnnotations() {
        throw new UnsupportedOperationException("No annotations");
    }

    @Nullable
    public Object getValue(@Nullable Object owner) {
        return null;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean hasAnnotation(@Nonnull Class<? extends Annotation> annotationOfInterest) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationOfInterest.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Class<?> type = this.getClassOfDeclaredType();
        StringBuilder description = new StringBuilder().append('\"').append(type.getSimpleName()).append(' ').append(this.name).append('\"');
        if (this.parent != null) {
            description.append("\r\n  when initializing ").append(this.parent);
        }
        return description.toString();
    }
}

