/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mockit.Injectable;
import mockit.Tested;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedField;
import mockit.internal.injection.TestedObject;

public final class TestedClassInstantiations {
    private static final int FIELD_ACCESS_MASK = 4104;
    private static final int METHOD_ACCESS_MASK = 5568;
    @Nonnull
    private final List<TestedField> testedFields = new LinkedList<TestedField>();
    @Nonnull
    private final List<InjectionProvider> injectableFields = new ArrayList<InjectionProvider>();
    @Nonnull
    final InjectionState injectionState = new InjectionState();

    public boolean findTestedAndInjectableMembers(@Nonnull Class<?> testClass) {
        this.findAllTestedAndInjectableMembersInTestClassHierarchy(testClass);
        return this.injectionState.injectionProviders.setInjectables(this.injectableFields) || !this.testedFields.isEmpty() || this.injectionState.interfaceResolution.canResolveInterfaces();
    }

    private void findAllTestedAndInjectableMembersInTestClassHierarchy(@Nonnull Class<?> testClass) {
        Class<?> superclass = testClass.getSuperclass();
        if (superclass.getClassLoader() != null) {
            this.findAllTestedAndInjectableMembersInTestClassHierarchy(superclass);
        }
        this.examineInstanceFields(testClass);
        this.examineMethods(testClass);
    }

    private void examineInstanceFields(@Nonnull Class<?> testClass) {
        for (Field candidateField : testClass.getDeclaredFields()) {
            if ((candidateField.getModifiers() & 0x1008) != 0) continue;
            this.addAsTestedOrInjectableFieldIfApplicable(candidateField);
        }
    }

    private void examineMethods(@Nonnull Class<?> testClass) {
        for (Method candidateMethod : testClass.getDeclaredMethods()) {
            if ((candidateMethod.getModifiers() & 0x15C0) != 0) continue;
            this.addAsTestedMethodIfApplicable(candidateMethod);
        }
    }

    private void addAsTestedOrInjectableFieldIfApplicable(@Nonnull Field fieldFromTestClass) {
        for (Annotation fieldAnnotation : fieldFromTestClass.getDeclaredAnnotations()) {
            if (fieldAnnotation instanceof Injectable) {
                MockedType mockedType = new MockedType(fieldFromTestClass);
                this.injectableFields.add(mockedType);
                break;
            }
            Tested testedMetadata = TestedObject.getTestedAnnotationIfPresent(fieldAnnotation);
            if (testedMetadata == null) continue;
            TestedField testedField = new TestedField(this.injectionState, fieldFromTestClass, testedMetadata);
            this.testedFields.add(testedField);
            break;
        }
    }

    private void addAsTestedMethodIfApplicable(@Nonnull Method methodFromTestClass) {
        for (Annotation methodAnnotation : methodFromTestClass.getDeclaredAnnotations()) {
            Tested testedMetadata = TestedObject.getTestedAnnotationIfPresent(methodAnnotation);
            if (testedMetadata == null) continue;
            this.addTestedMethodIfApplicable(methodFromTestClass);
            break;
        }
    }

    private void addTestedMethodIfApplicable(@Nonnull Method methodFromTestClass) {
        ParameterizedType interfaceType;
        Type parameterType;
        Type[] parameterTypes;
        Class<?> returnType = methodFromTestClass.getReturnType();
        if (returnType == Class.class && (parameterTypes = methodFromTestClass.getGenericParameterTypes()).length == 1 && (parameterType = parameterTypes[0]) instanceof ParameterizedType && (interfaceType = (ParameterizedType)parameterType).getRawType() == Class.class) {
            this.injectionState.interfaceResolution.addInterfaceResolutionMethod(interfaceType, methodFromTestClass);
        }
    }

    public void assignNewInstancesToTestedFieldsFromBaseClasses(@Nonnull Object testClassInstance) {
        this.injectionState.setInjectables(testClassInstance, this.injectableFields);
        Class<?> testClass = testClassInstance.getClass();
        for (TestedField testedField : this.testedFields) {
            if (!testedField.isFromBaseClass(testClass)) continue;
            this.instantiateTestedObject(testClassInstance, testedField);
        }
    }

    public void assignNewInstancesToTestedFields(@Nonnull Object testClassInstance, boolean beforeSetup, @Nonnull List<? extends InjectionProvider> injectableParameters) {
        List<InjectionProvider> injectables = this.injectableFields;
        if (!injectableParameters.isEmpty()) {
            injectables = new ArrayList<InjectionProvider>(injectables);
            injectables.addAll(injectableParameters);
        }
        this.injectionState.setInjectables(testClassInstance, injectables);
        for (TestedField testedField : this.testedFields) {
            if (beforeSetup && !testedField.isAvailableDuringSetup()) continue;
            this.instantiateTestedObject(testClassInstance, testedField);
        }
    }

    private void instantiateTestedObject(@Nonnull Object testClassInstance, @Nonnull TestedObject testedObject) {
        try {
            testedObject.instantiateWithInjectableValues(testClassInstance);
        }
        finally {
            this.injectionState.injectionProviders.resetConsumedInjectionProviders();
        }
    }

    public void clearTestedObjects() {
        this.injectionState.lifecycleMethods.executeTerminationMethodsIfAny();
        this.injectionState.clearTestedObjectsAndInstantiatedDependencies();
        this.resetTestedFields(false);
    }

    private void resetTestedFields(boolean duringTearDown) {
        Object testClassInstance = this.injectionState.getCurrentTestClassInstance();
        if (testClassInstance != null) {
            for (TestedObject testedObject : this.testedFields) {
                testedObject.clearIfAutomaticCreation(testClassInstance, duringTearDown);
            }
        }
    }

    public void clearTestedObjectsCreatedDuringSetup() {
        this.resetTestedFields(true);
    }

    @Nonnull
    public BeanExporter getBeanExporter() {
        return this.injectionState.getBeanExporter();
    }
}

