/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.full;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.enterprise.context.Conversation;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.CommonDataSource;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.injection.full.JPADependencies;
import mockit.internal.injection.full.ServletDependencies;
import mockit.internal.injection.full.TestConversation;
import mockit.internal.injection.full.TestDataSource;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.util.Utilities;

public final class FullInjection {
    private static final int INVALID_TYPES = 25600;
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    private final String testedClassName;
    @Nonnull
    private final String testedName;
    @Nullable
    private final ServletDependencies servletDependencies;
    @Nullable
    private final JPADependencies jpaDependencies;
    @Nullable
    private Class<?> dependencyClass;
    @Nullable
    private InjectionProvider parentInjectionProvider;

    public FullInjection(@Nonnull InjectionState injectionState, @Nonnull Class<?> testedClass, @Nonnull String testedName) {
        this.injectionState = injectionState;
        this.testedClassName = testedClass.getSimpleName();
        this.testedName = testedName;
        this.servletDependencies = InjectionPoint.SERVLET_CLASS == null ? null : new ServletDependencies(injectionState);
        this.jpaDependencies = InjectionPoint.PERSISTENCE_UNIT_CLASS == null ? null : new JPADependencies(injectionState);
    }

    @Nullable
    public Object createOrReuseInstance(@Nonnull TestedClass testedClass, @Nonnull Injector injector, @Nullable InjectionProvider injectionProvider, @Nullable String qualifiedName) {
        this.setInjectionProvider(injectionProvider);
        InjectionPoint injectionPoint = this.getInjectionPoint(testedClass, injectionProvider, qualifiedName);
        Object dependency = this.injectionState.getInstantiatedDependency(testedClass, injectionPoint);
        if (dependency != null) {
            return dependency;
        }
        Class<?> typeToInject = this.dependencyClass;
        if (typeToInject == Logger.class) {
            return FullInjection.createLogger(testedClass);
        }
        if (typeToInject == null || !FullInjection.isInstantiableType(typeToInject)) {
            return null;
        }
        return this.createInstance(testedClass, injector, injectionProvider, injectionPoint);
    }

    public void setInjectionProvider(@Nullable InjectionProvider injectionProvider) {
        if (injectionProvider != null) {
            injectionProvider.parent = this.parentInjectionProvider;
        }
        this.parentInjectionProvider = injectionProvider;
    }

    @Nonnull
    private InjectionPoint getInjectionPoint(@Nonnull TestedClass testedClass, @Nullable InjectionProvider injectionProvider, @Nullable String qualifiedName) {
        if (injectionProvider == null) {
            this.dependencyClass = testedClass.targetClass;
            return new InjectionPoint(this.dependencyClass, qualifiedName, true);
        }
        Type dependencyType = injectionProvider.getDeclaredType();
        if (dependencyType instanceof TypeVariable) {
            dependencyType = testedClass.reflection.resolveTypeVariable((TypeVariable)dependencyType);
            this.dependencyClass = Utilities.getClassType(dependencyType);
        } else {
            this.dependencyClass = injectionProvider.getClassOfDeclaredType();
        }
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            return new InjectionPoint(this.dependencyClass, qualifiedName, true);
        }
        if (this.jpaDependencies != null && JPADependencies.isApplicable(this.dependencyClass)) {
            for (Annotation annotation : injectionProvider.getAnnotations()) {
                InjectionPoint injectionPoint = this.jpaDependencies.getInjectionPointIfAvailable(annotation);
                if (injectionPoint == null) continue;
                return injectionPoint;
            }
        }
        return new InjectionPoint(dependencyType, injectionProvider.getName(), false);
    }

    @Nonnull
    private static Object createLogger(@Nonnull TestedClass testedClass) {
        TestedClass testedClassWithLogger = testedClass.parent;
        assert (testedClassWithLogger != null);
        return Logger.getLogger(testedClassWithLogger.nameOfTestedClass);
    }

    public static boolean isInstantiableType(@Nonnull Class<?> type) {
        if (type.isPrimitive() || type.isArray() || type.isAnnotation()) {
            return false;
        }
        if (type.isInterface()) {
            return true;
        }
        int typeModifiers = type.getModifiers();
        if ((typeModifiers & 0x6400) != 0 || !Modifier.isStatic(typeModifiers) && type.isMemberClass()) {
            return false;
        }
        return type.getClassLoader() != null;
    }

    @Nullable
    private Object createInstance(@Nonnull TestedClass testedClass, @Nonnull Injector injector, @Nullable InjectionProvider injectionProvider, @Nonnull InjectionPoint injectionPoint) {
        Class<?> resolvedType;
        Class<?> typeToInject = this.dependencyClass;
        Object dependency = null;
        if (typeToInject.isInterface() && (dependency = this.createInstanceOfSupportedInterfaceIfApplicable(testedClass, typeToInject, injectionPoint, injectionProvider)) == null && typeToInject.getClassLoader() != null && (resolvedType = this.injectionState.resolveInterface(typeToInject)) != null && !resolvedType.isInterface()) {
            testedClass = new TestedClass(resolvedType, resolvedType);
            typeToInject = resolvedType;
        }
        if (dependency == null) {
            dependency = this.createAndRegisterNewInstance(typeToInject, testedClass, injector, injectionPoint, injectionProvider);
        }
        return dependency;
    }

    @Nullable
    private Object createInstanceOfSupportedInterfaceIfApplicable(@Nonnull TestedClass testedClass, @Nonnull Class<?> typeToInject, @Nonnull InjectionPoint injectionPoint, @Nullable InjectionProvider injectionProvider) {
        Object dependency = null;
        if (CommonDataSource.class.isAssignableFrom(typeToInject)) {
            dependency = this.createAndRegisterDataSource(testedClass, injectionPoint, injectionProvider);
        } else if (InjectionPoint.INJECT_CLASS != null && typeToInject == Provider.class) {
            assert (injectionProvider != null);
            dependency = this.createProviderInstance(injectionProvider);
        } else if (InjectionPoint.CONVERSATION_CLASS != null && typeToInject == Conversation.class) {
            dependency = this.createAndRegisterConversationInstance();
        } else if (this.servletDependencies != null && ServletDependencies.isApplicable(typeToInject)) {
            dependency = this.servletDependencies.createAndRegisterDependency(typeToInject);
        } else if (this.jpaDependencies != null && JPADependencies.isApplicable(typeToInject)) {
            dependency = this.jpaDependencies.createAndRegisterDependency(typeToInject, injectionPoint, injectionProvider);
        }
        return dependency;
    }

    @Nullable
    private Object createAndRegisterDataSource(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint, @Nullable InjectionProvider injectionProvider) {
        if (injectionProvider == null || !injectionProvider.hasAnnotation(Resource.class)) {
            return null;
        }
        TestDataSource dsCreation = new TestDataSource(injectionPoint);
        CommonDataSource dataSource = dsCreation.createIfDataSourceDefinitionAvailable(testedClass);
        if (dataSource != null) {
            this.injectionState.saveInstantiatedDependency(injectionPoint, dataSource);
        }
        return dataSource;
    }

    @Nonnull
    private Object createProviderInstance(@Nonnull InjectionProvider injectionProvider) {
        ParameterizedType genericType = (ParameterizedType)injectionProvider.getDeclaredType();
        final Class providedClass = (Class)genericType.getActualTypeArguments()[0];
        if (providedClass.isAnnotationPresent(Singleton.class)) {
            return new Provider<Object>(){
                private Object dependency;

                public synchronized Object get() {
                    if (this.dependency == null) {
                        this.dependency = FullInjection.this.createNewInstance(providedClass, true);
                    }
                    return this.dependency;
                }
            };
        }
        return () -> this.createNewInstance(providedClass, false);
    }

    @Nullable
    private Object createNewInstance(@Nonnull Class<?> classToInstantiate, boolean required) {
        if (classToInstantiate.isInterface()) {
            return null;
        }
        if (classToInstantiate.getClassLoader() == null) {
            return ConstructorReflection.newInstanceUsingDefaultConstructorIfAvailable(classToInstantiate);
        }
        return new TestedObjectCreation(this.injectionState, this, classToInstantiate).create(required, false);
    }

    @Nonnull
    private Object createAndRegisterConversationInstance() {
        TestConversation conversation = new TestConversation();
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)Conversation.class));
        this.injectionState.saveInstantiatedDependency(injectionPoint, conversation);
        return conversation;
    }

    @Nullable
    private Object createAndRegisterNewInstance(@Nonnull Class<?> typeToInstantiate, @Nonnull TestedClass testedClass, @Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint, @Nullable InjectionProvider injectionProvider) {
        Object dependency = this.createNewInstance(typeToInstantiate, injectionProvider != null && injectionProvider.isRequired());
        if (dependency != null) {
            if (injectionPoint.name == null) {
                assert (injectionProvider != null);
                injectionPoint = new InjectionPoint(injectionPoint.type, injectionProvider.getName());
            }
            this.registerNewInstance(testedClass, injector, injectionPoint, dependency);
        }
        return dependency;
    }

    private void registerNewInstance(@Nonnull TestedClass testedClass, @Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint, @Nonnull Object dependency) {
        this.injectionState.saveInstantiatedDependency(injectionPoint, dependency);
        Class<?> instantiatedClass = dependency.getClass();
        if (testedClass.isClassFromSameModuleOrSystemAsTestedClass(instantiatedClass)) {
            injector.fillOutDependenciesRecursively(dependency, testedClass);
            this.injectionState.lifecycleMethods.findLifecycleMethods(instantiatedClass);
            this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(instantiatedClass, dependency);
        }
    }

    public String toString() {
        InjectionProvider injectionProvider;
        String description = "@Tested object \"" + this.testedClassName + " " + this.testedName + "\"";
        if (this.parentInjectionProvider != null && (injectionProvider = this.parentInjectionProvider.parent) != null) {
            description = injectionProvider + "\r\n  of " + description;
        }
        return description;
    }

    public void clear() {
        this.parentInjectionProvider = null;
    }
}

