/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import mockit.MockUp;
import mockit.coverage.CodeCoverage;
import mockit.integration.junit4.FakeFrameworkMethod;
import mockit.integration.junit4.FakeRunNotifier;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.StackTrace;

final class JMockitInitialization {
    private JMockitInitialization() {
    }

    static void initialize(@Nonnull Instrumentation inst, boolean activateCoverage) {
        if (activateCoverage || CodeCoverage.active()) {
            inst.addTransformer(new CodeCoverage());
        }
        JMockitInitialization.applyInternalStartupFakesAsNeeded();
        JMockitInitialization.applyUserSpecifiedStartupFakesIfAny();
    }

    private static void applyInternalStartupFakesAsNeeded() {
        if (ClassLoad.searchTypeInClasspath("org.junit.runners.model.FrameworkMethod", true) != null || ClassLoad.searchTypeInClasspath("org.junit.vintage.engine.VintageTestEngine", true) != null) {
            new FakeRunNotifier();
            new FakeFrameworkMethod();
        }
        if (ClassLoad.searchTypeInClasspath("org.junit.jupiter.api.extension.Extension", true) != null) {
            System.setProperty("junit.jupiter.extensions.autodetection.enabled", "true");
        }
    }

    private static void applyUserSpecifiedStartupFakesIfAny() {
        Collection<String> fakeClasses = JMockitInitialization.getFakeClasses();
        for (String fakeClassName : fakeClasses) {
            JMockitInitialization.applyStartupFake(fakeClassName);
        }
    }

    @Nonnull
    private static Collection<String> getFakeClasses() {
        String commaOrSpaceSeparatedValues = System.getProperty("fakes");
        if (commaOrSpaceSeparatedValues == null) {
            return Collections.emptyList();
        }
        String[] fakeClassNames = commaOrSpaceSeparatedValues.split("\\s*,\\s*|\\s+");
        HashSet<String> uniqueClassNames = new HashSet<String>(Arrays.asList(fakeClassNames));
        uniqueClassNames.remove("");
        return uniqueClassNames;
    }

    private static void applyStartupFake(@Nonnull String fakeClassName) {
        String argument = null;
        int p = fakeClassName.indexOf(61);
        if (p > 0) {
            argument = fakeClassName.substring(p + 1);
            fakeClassName = fakeClassName.substring(0, p);
        }
        try {
            Class fakeClass = ClassLoad.loadClassAtStartup(fakeClassName);
            if (MockUp.class.isAssignableFrom(fakeClass)) {
                if (argument == null) {
                    ConstructorReflection.newInstanceUsingDefaultConstructor(fakeClass);
                } else {
                    ConstructorReflection.newInstanceUsingCompatibleConstructor(fakeClass, argument);
                }
            }
        }
        catch (UnsupportedOperationException fakeClass) {
        }
        catch (Throwable unexpectedFailure) {
            StackTrace.filterStackTrace(unexpectedFailure);
            unexpectedFailure.printStackTrace();
        }
    }
}

