/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassIdentification;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.ClassLoadingBridgeFields;
import mockit.internal.startup.JMockitInitialization;
import mockit.internal.state.CachedClassfiles;

public final class Startup {
    @Nullable
    private static Instrumentation instrumentation;
    public static boolean initializing;

    private Startup() {
    }

    public static void premain(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        ClassLoadingBridgeFields.createSyntheticFieldsInJREClassToHoldClassLoadingBridges(inst);
        instrumentation = inst;
        inst.addTransformer(CachedClassfiles.INSTANCE, true);
        initializing = true;
        try {
            JMockitInitialization.initialize(inst, "coverage".equals(agentArgs));
        }
        finally {
            initializing = false;
        }
        inst.addTransformer(new ExpectationsTransformer());
    }

    @Nonnull
    public static Instrumentation instrumentation() {
        return instrumentation;
    }

    public static void verifyInitialization() {
        if (instrumentation == null) {
            throw new IllegalStateException("JMockit didn't get initialized; please check the -javaagent JVM initialization parameter was used");
        }
    }

    public static void retransformClass(@Nonnull Class<?> aClass) {
        try {
            instrumentation.retransformClasses(aClass);
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
            // empty catch block
        }
    }

    public static void redefineMethods(@Nonnull ClassIdentification classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Class<?> loadedClass = classToRedefine.getLoadedClass();
        Startup.redefineMethods(loadedClass, modifiedClassfile);
    }

    public static void redefineMethods(@Nonnull Class<?> classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Startup.redefineMethods(new ClassDefinition(classToRedefine, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        try {
            instrumentation.redefineClasses(classDefs);
        }
        catch (ClassNotFoundException | UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        catch (InternalError ignore) {
            for (ClassDefinition classDef : classDefs) {
                Startup.detectMissingDependenciesIfAny(classDef.getDefinitionClass());
            }
        }
    }

    private static void detectMissingDependenciesIfAny(@Nonnull Class<?> mockedClass) {
        try {
            Class.forName(mockedClass.getName(), false, mockedClass.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to mock " + mockedClass + " due to a missing dependency", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nullable
    public static Class<?> getClassIfLoaded(@Nonnull String classDescOrName) {
        Class[] loadedClasses;
        String className = classDescOrName.replace('/', '.');
        for (Class aClass : loadedClasses = instrumentation.getAllLoadedClasses()) {
            if (!aClass.getName().equals(className)) continue;
            return aClass;
        }
        return null;
    }
}

