/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ObjectMethods {
    private ObjectMethods() {
    }

    @Nonnull
    public static String objectIdentity(@Nonnull Object obj) {
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    @Nullable
    public static Object evaluateOverride(@Nonnull Object obj, @Nonnull String methodNameAndDesc, @Nonnull Object[] args) {
        if ("equals(Ljava/lang/Object;)Z".equals(methodNameAndDesc)) {
            return obj == args[0];
        }
        if ("hashCode()I".equals(methodNameAndDesc)) {
            return System.identityHashCode(obj);
        }
        if ("toString()Ljava/lang/String;".equals(methodNameAndDesc)) {
            return ObjectMethods.objectIdentity(obj);
        }
        if (args.length == 1 && methodNameAndDesc.startsWith("compareTo(L") && methodNameAndDesc.endsWith(";)I") && obj instanceof Comparable) {
            Object arg = args[0];
            if (obj == arg) {
                return 0;
            }
            return System.identityHashCode(obj) > System.identityHashCode(arg) ? 1 : -1;
        }
        return null;
    }

    public static boolean isMethodFromObject(@Nonnull String name, @Nonnull String desc) {
        return "equals".equals(name) && "(Ljava/lang/Object;)Z".equals(desc) || "hashCode".equals(name) && "()I".equals(desc) || "toString".equals(name) && "()Ljava/lang/String;".equals(desc) || "finalize".equals(name) && "()V".equals(desc);
    }
}

