/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.bs;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.ICharsCore;
import com.github.houbb.chars.scan.api.ICharsReplaceFactory;
import com.github.houbb.chars.scan.api.ICharsReplaceHash;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.chars.scan.support.core.CharsCores;
import com.github.houbb.chars.scan.support.hash.CharsReplaceHashes;
import com.github.houbb.chars.scan.support.replace.CharsReplaces;
import com.github.houbb.chars.scan.support.scan.CharsScans;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.trie.api.ITrieTree;
import com.github.houbb.trie.impl.TrieTrees;
import java.util.Set;

public class CharsScanBs {
    private ICharsCore charsCore = CharsCores.defaults();
    private ICharsReplaceHash charsReplaceHash = CharsReplaceHashes.defaults();
    private ICharsScanFactory charScanFactory = CharsScans.defaults();
    private ICharsReplaceFactory charsReplaceFactory = CharsReplaces.defaults();
    private int scanStartIndex = 0;
    private Set<Character> prefixCharSet = InnerCharUtil.DEFAULT_PREFIX_SET;
    private ITrieTree whiteListTrie = TrieTrees.node();
    private CharsScanContext context;

    public static CharsScanBs newInstance() {
        return new CharsScanBs();
    }

    public CharsScanBs whiteListTrie(ITrieTree whiteListTrie) {
        ArgUtil.notNull((Object)whiteListTrie, (String)"whiteListTrie");
        this.whiteListTrie = whiteListTrie;
        return this;
    }

    public CharsScanBs charsCore(ICharsCore charsCore) {
        ArgUtil.notNull((Object)charsCore, (String)"charsCore");
        this.charsCore = charsCore;
        return this;
    }

    public CharsScanBs charsReplaceHash(ICharsReplaceHash charsReplaceHash) {
        ArgUtil.notNull((Object)charsReplaceHash, (String)"charsReplaceHash");
        this.charsReplaceHash = charsReplaceHash;
        return this;
    }

    public CharsScanBs charsScanFactory(ICharsScanFactory charScanFactory) {
        ArgUtil.notNull((Object)charScanFactory, (String)"charScanFactory");
        this.charScanFactory = charScanFactory;
        return this;
    }

    public CharsScanBs charsReplaceFactory(ICharsReplaceFactory charsReplaceFactory) {
        ArgUtil.notNull((Object)charsReplaceFactory, (String)"charsReplaceFactory");
        this.charsReplaceFactory = charsReplaceFactory;
        return this;
    }

    public CharsScanBs prefixCharSet(Set<Character> prefixCharSet) {
        ArgUtil.notNull(prefixCharSet, (String)"prefixCharSet");
        this.prefixCharSet = prefixCharSet;
        return this;
    }

    public CharsScanBs scanStartIndex(int scanStartIndex) {
        this.scanStartIndex = scanStartIndex;
        return this;
    }

    public CharsScanBs init() {
        this.context = new CharsScanContext();
        this.context.setCharScanFactory(this.charScanFactory);
        this.context.setCharsReplaceFactory(this.charsReplaceFactory);
        this.context.setCharsReplaceHash(this.charsReplaceHash);
        this.context.setScanStartIndex(this.scanStartIndex);
        this.context.setPrefixCharSet(this.prefixCharSet);
        this.context.setWhiteListTrie(this.whiteListTrie);
        return this;
    }

    public String scanAndReplace(String text) {
        return this.charsCore.scanAndReplace(text, this.context);
    }
}

