/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.heaven.util.lang.CharUtil;
import java.util.HashSet;
import java.util.Set;

public class AddressConditionCharScan
extends AbstractConditionCharScan {
    private static final Set<Character> PLACE_CHAR_SET;

    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        if (super.getBuffer().length() == 0) {
            return CharUtil.isChinese((char)c);
        }
        return CharUtil.isChinese((char)c) || CharUtil.isDigitOrLetter((char)c) || '-' == c;
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        int bufferLen = super.getBuffer().length();
        if (bufferLen < 6 || bufferLen > 100) {
            return false;
        }
        return this.containsKeyword();
    }

    private boolean containsKeyword() {
        StringBuilder builder = super.getBuffer();
        int bufferLen = builder.length();
        int maxLen = Math.min(50, bufferLen);
        for (int j = 0; j < maxLen; ++j) {
            char bc = builder.charAt(j);
            if (!PLACE_CHAR_SET.contains(Character.valueOf(bc))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.ADDRESS.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.ADDRESS.getPriority();
    }

    static {
        String keywords = "\u56fd\u7701\u5e02\u53bf\u533a\u8def\u9547\u4e61\u6751\u8857\u9053\u56ed\u9662\u91cc\u5382\u5f04";
        PLACE_CHAR_SET = new HashSet<Character>(keywords.length());
        for (char c : keywords.toCharArray()) {
            PLACE_CHAR_SET.add(Character.valueOf(c));
        }
    }
}

