/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerBankLuhnHelper;
import com.github.houbb.heaven.util.lang.CharUtil;

public class BankCardConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c);
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        int bufferLen = super.getBuffer().length();
        if (bufferLen < 15 || bufferLen > 19) {
            return false;
        }
        return InnerBankLuhnHelper.isValidBankNo(super.getBuffer());
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.BANK_CARD.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.BANK_CARD.getPriority();
    }
}

