/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerChineseNameUtil;
import com.github.houbb.heaven.util.lang.CharUtil;

public class ChineseNameConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isChinese((char)c);
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        StringBuilder buffer = super.getBuffer();
        int bufferLen = buffer.length();
        if (bufferLen < 2 || bufferLen > 3) {
            return false;
        }
        char firstChar = buffer.charAt(0);
        return InnerChineseNameUtil.isFamilyName(firstChar);
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.CHINESE_NAME.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.CHINESE_NAME.getPriority();
    }
}

