/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.List;

public class EmailConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isEmilChar((char)c);
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        String string = super.getBuffer().toString();
        List subArray = StringUtil.splitToList((String)string, (char)'@');
        if (subArray.size() != 2) {
            return false;
        }
        String beforeAt = (String)subArray.get(0);
        if (beforeAt.length() < 1) {
            return false;
        }
        String afterAt = (String)subArray.get(1);
        if (afterAt.length() < 4) {
            return false;
        }
        List domainList = StringUtil.splitToList((String)afterAt, (char)'.');
        if (domainList.size() < 2) {
            return false;
        }
        String domainFirst = (String)domainList.get(0);
        if (domainFirst.length() < 1) {
            return false;
        }
        String domainLast = (String)domainList.get(domainList.size() - 1);
        return domainLast.length() >= 2;
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.EMAIL.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.EMAIL.getPriority();
    }
}

