/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.List;

public class IPV4ConditionCharScan
extends AbstractConditionCharScan {
    @Override
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return CharUtil.isNumber((char)c) || '.' == c;
    }

    @Override
    protected boolean isStringMatchCondition(int i, char c, char[] chars, CharsScanContext context) {
        int bufferLen = super.getBuffer().length();
        if (bufferLen < 7 || bufferLen > 15) {
            return false;
        }
        String string = super.getBuffer().toString();
        List stringList = StringUtil.splitToList((String)string, (char)'.');
        if (stringList.size() != 4) {
            return false;
        }
        for (String numStr : stringList) {
            int integer = InnerCharUtil.parseInt(numStr);
            if (integer >= 0 && integer <= 256) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.IPV4.getScanType();
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.IPV4.getPriority();
    }
}

