/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan.factory;

import com.github.houbb.chars.scan.api.ICharsScan;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.exception.CharsScanException;
import com.github.houbb.chars.scan.support.scan.AddressExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.BankCardConditionCharScan;
import com.github.houbb.chars.scan.support.scan.BirthdayConditionCharScan;
import com.github.houbb.chars.scan.support.scan.ChineseNameExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.EmailExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.GPSConditionCharScan;
import com.github.houbb.chars.scan.support.scan.IPV4ConditionCharScan;
import com.github.houbb.chars.scan.support.scan.IdNoConditionCharScan;
import com.github.houbb.chars.scan.support.scan.MergeExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.MergeNameAddressConditionCharScan;
import com.github.houbb.chars.scan.support.scan.MergeNumsConditionCharScan;
import com.github.houbb.chars.scan.support.scan.PassportConditionCharScan;
import com.github.houbb.chars.scan.support.scan.PhoneConditionCharScan;
import com.github.houbb.chars.scan.support.scan.factory.AbstractCharsScanFactory;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SimpleCharsScanFactory
extends AbstractCharsScanFactory
implements ICharsScanFactory {
    private final List<String> scanTypeList;

    public SimpleCharsScanFactory(List<String> scanTypeList) {
        this.scanTypeList = scanTypeList;
    }

    public SimpleCharsScanFactory() {
        this(Arrays.asList(CharsScanTypeEnum.MERGE_NUMS.getScanType(), CharsScanTypeEnum.MERGE_EXPAND.getScanType(), CharsScanTypeEnum.IPV4.getScanType(), CharsScanTypeEnum.PASSPORT.getScanType(), CharsScanTypeEnum.GPS.getScanType()));
    }

    public static String buildMergeNums(Collection<String> numScanTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CharsScanTypeEnum.MERGE_NUMS.getScanType()).append(":");
        String scanTypes = StringUtil.join(numScanTypes, (String)"&");
        stringBuilder.append(scanTypes);
        return stringBuilder.toString();
    }

    public static String buildMergeExpands(Collection<String> scanTypesCollect) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CharsScanTypeEnum.MERGE_EXPAND.getScanType()).append(":");
        String scanTypes = StringUtil.join(scanTypesCollect, (String)"&");
        stringBuilder.append(scanTypes);
        return stringBuilder.toString();
    }

    public static List<String> getMergeParams(String[] scanTypes) {
        if (scanTypes.length <= 1) {
            return Collections.emptyList();
        }
        String paramsRaw = scanTypes[1];
        return StringUtil.splitToList((String)paramsRaw, (char)'&');
    }

    @Override
    public List<String> scanTypeList() {
        return this.scanTypeList;
    }

    @Override
    public ICharsScan getCharScan(String scanTypeRaw) {
        String[] scanTypes = scanTypeRaw.split(":");
        String scanType = scanTypes[0];
        List<String> mergeParams = SimpleCharsScanFactory.getMergeParams(scanTypes);
        if (CharsScanTypeEnum.MERGE_NUMS.getScanType().equals(scanType)) {
            if (CollectionUtil.isNotEmpty(mergeParams)) {
                return new MergeNumsConditionCharScan(mergeParams);
            }
            return new MergeNumsConditionCharScan();
        }
        if (CharsScanTypeEnum.MERGE_EXPAND.getScanType().equals(scanType)) {
            if (CollectionUtil.isNotEmpty(mergeParams)) {
                return new MergeExpandConditionCharScan(mergeParams);
            }
            return new MergeExpandConditionCharScan();
        }
        if (CharsScanTypeEnum.MERGE_NAME_ADDRESS.getScanType().equals(scanType)) {
            return new MergeNameAddressConditionCharScan();
        }
        if (CharsScanTypeEnum.EMAIL.getScanType().equals(scanType)) {
            return new EmailExpandConditionCharScan();
        }
        if (CharsScanTypeEnum.ADDRESS.getScanType().equals(scanType)) {
            return new AddressExpandConditionCharScan();
        }
        if (CharsScanTypeEnum.CHINESE_NAME.getScanType().equals(scanType)) {
            return new ChineseNameExpandConditionCharScan();
        }
        if (CharsScanTypeEnum.ID_NO.getScanType().equals(scanType)) {
            return new IdNoConditionCharScan();
        }
        if (CharsScanTypeEnum.PHONE.getScanType().equals(scanType)) {
            return new PhoneConditionCharScan();
        }
        if (CharsScanTypeEnum.BANK_CARD.getScanType().equals(scanType)) {
            return new BankCardConditionCharScan();
        }
        if (CharsScanTypeEnum.GPS.getScanType().equals(scanType)) {
            return new GPSConditionCharScan();
        }
        if (CharsScanTypeEnum.IPV4.getScanType().equals(scanType)) {
            return new IPV4ConditionCharScan();
        }
        if (CharsScanTypeEnum.PASSPORT.getScanType().equals(scanType)) {
            return new PassportConditionCharScan();
        }
        if (CharsScanTypeEnum.BIRTHDAY.getScanType().equals(scanType)) {
            return new BirthdayConditionCharScan();
        }
        throw new CharsScanException("Not support type for " + scanType);
    }
}

