/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.util;

import com.github.houbb.chars.scan.bs.CharsScanBs;
import com.github.houbb.chars.scan.util.InnerCharsScanPropertyBuilder;
import com.github.houbb.heaven.annotation.CommonEager;
import com.github.houbb.heaven.util.util.DateUtil;
import com.github.houbb.property.bs.PropertyBs;

public class CharsScanPropertyHelper {
    private static final PropertyBs PROPERTY_BS = CharsScanPropertyHelper.buildPropertyBs("chars-scan-config.properties");

    @CommonEager
    private static PropertyBs buildPropertyBs(String path) {
        try {
            return PropertyBs.getInstance((String)path);
        }
        catch (Exception e) {
            String logFormat = "WARN: [chars-scan] [%s] [%s] config file not found, use default config.";
            String log = String.format(logFormat, DateUtil.getCurrentDateTimeStr(), path);
            System.out.println(log);
            return PropertyBs.getInstance((String)"chars-scan-config-default.properties");
        }
    }

    private static CharsScanBs buildCharsScanBs() {
        String prefix = PROPERTY_BS.getOrDefault("chars.scan.prefix", "\uff1a\u2018\u201c\uff0c| ,:\\\"'=");
        String scanList = PROPERTY_BS.getOrDefault("chars.scan.scanList", "1,2,3,4,9");
        String replaceList = PROPERTY_BS.getOrDefault("chars.scan.replaceList", "1,2,3,4,9");
        String defaultReplace = PROPERTY_BS.getOrDefault("chars.scan.defaultReplace", "12");
        String replaceHash = PROPERTY_BS.getOrDefault("chars.scan.replaceHash", "md5");
        String whiteList = PROPERTY_BS.getOrDefault("chars.scan.whiteList", "");
        return InnerCharsScanPropertyBuilder.buildCharsScanBs(prefix, scanList, replaceList, defaultReplace, replaceHash, whiteList);
    }

    public static String scanAndReplace(String text) {
        CharsScanBs charsScanBs = CharsScanPropertyHelper.buildCharsScanBs();
        return charsScanBs.scanAndReplace(text);
    }
}

