/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.util;

import com.github.houbb.heaven.annotation.CommonEager;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InnerCharUtil {
    private static final Set<Character> PLACE_CHAR_SET;
    public static final Set<Character> DEFAULT_PREFIX_SET;

    public static boolean isAddressKeyword(char c) {
        return PLACE_CHAR_SET.contains(Character.valueOf(c));
    }

    public static boolean isValidDate(StringBuilder buffer, int startIx) {
        int year = 1000 * InnerCharUtil.getCharInt(buffer.charAt(startIx)) + 100 * InnerCharUtil.getCharInt(buffer.charAt(1 + startIx)) + 10 * InnerCharUtil.getCharInt(buffer.charAt(2 + startIx)) + InnerCharUtil.getCharInt(buffer.charAt(3 + startIx));
        if (year < 1900 || year > 2099) {
            return false;
        }
        int month = 10 * InnerCharUtil.getCharInt(buffer.charAt(4 + startIx)) + InnerCharUtil.getCharInt(buffer.charAt(5 + startIx));
        if (month < 1 || month > 12) {
            return false;
        }
        int day = 10 * InnerCharUtil.getCharInt(buffer.charAt(6 + startIx)) + InnerCharUtil.getCharInt(buffer.charAt(7 + startIx));
        return day >= 1 && day <= 31;
    }

    public static int parseInt(String text) {
        int len = text.length();
        int sum = 0;
        int weight = 1;
        char[] chars = text.toCharArray();
        for (int i = len - 1; i >= 0; --i) {
            int val = InnerCharUtil.getCharInt(chars[i]);
            sum += weight * val;
            weight *= 10;
        }
        return sum;
    }

    public static int getCharInt(char c) {
        return c - 48;
    }

    @CommonEager
    public static Set<Character> getCharSet(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return Collections.emptySet();
        }
        char[] chars = text.toCharArray();
        HashSet<Character> characterSet = new HashSet<Character>(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            characterSet.add(Character.valueOf(chars[i]));
        }
        return characterSet;
    }

    public static void appendChars(StringBuilder stringBuilder, char[] chars, int startIndex, int endIndex) {
        int len = endIndex - startIndex + 1;
        stringBuilder.append(chars, startIndex, len);
    }

    public static boolean isAddressChar(char c) {
        return CharUtil.isChinese((char)c) || CharUtil.isDigitOrLetter((char)c) || '-' == c;
    }

    private static boolean isDigitOrLetter(char c) {
        return Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    public static boolean isEmilChar(char c) {
        return InnerCharUtil.isDigitOrLetter(c) || '_' == c || '-' == c || c == '.';
    }

    static {
        String keywords = "\u56fd\u7701\u5e02\u53bf\u533a\u8def\u9547\u4e61\u6751\u8857\u9053\u56ed\u9662\u91cc\u5382\u5f04";
        PLACE_CHAR_SET = new HashSet<Character>(keywords.length());
        for (char c : keywords.toCharArray()) {
            PLACE_CHAR_SET.add(Character.valueOf(c));
        }
        DEFAULT_PREFIX_SET = InnerCharUtil.getCharSet(":\uff1a,\uff0c'\"\u2018\u201c=| +-*/()\uff08\uff09\u3010\u3011[]{}><");
    }
}

