/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.common.cache.core.support.clean;

import com.github.houbb.common.cache.core.dto.CommonCacheValueDto;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import java.util.Map;

public class CommonCacheCleanTask
implements Runnable {
    private static final Log LOG = LogFactory.getLog(CommonCacheCleanTask.class);
    private final Map<String, CommonCacheValueDto> map;

    public CommonCacheCleanTask(Map<String, CommonCacheValueDto> map) {
        ArgUtil.notNull(map, (String)"map");
        this.map = map;
    }

    @Override
    public void run() {
        LOG.debug("[Cache] \u5f00\u59cb\u6e05\u7406\u8fc7\u671f\u6570\u636e");
        long currentMills = System.currentTimeMillis();
        for (Map.Entry<String, CommonCacheValueDto> entry : this.map.entrySet()) {
            Long expireTime = entry.getValue().getExpireTime();
            if (expireTime == null || currentMills < expireTime) continue;
            String key = entry.getKey();
            this.map.remove(key);
            LOG.debug("[Cache] \u79fb\u9664 key: {}", new Object[]{key});
        }
        LOG.debug("[Cache] \u7ed3\u675f\u6e05\u7406\u8fc7\u671f\u6570\u636e");
    }
}

