/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class ClassGenericUtil {
    private ClassGenericUtil() {
    }

    private static List<Type> getGenericInterfaces(Class clazz) {
        Type superType;
        HashSet<Object> typeSet = new HashSet<Object>();
        Object[] types = clazz.getGenericInterfaces();
        if (ArrayUtil.isNotEmpty(types)) {
            typeSet.addAll(Arrays.asList(types));
        }
        if (ObjectUtil.isNotNull(superType = clazz.getGenericSuperclass()) && superType.getClass().isInterface()) {
            typeSet.add(superType);
        }
        return new ArrayList<Type>(typeSet);
    }

    public static Class getGenericType(Class clazz, Class interfaceClass, int index) {
        List<Type> typeList = ClassGenericUtil.getGenericInterfaces(clazz);
        for (Type type : typeList) {
            if (!(type instanceof ParameterizedType) || !interfaceClass.equals(((ParameterizedType)type).getRawType())) continue;
            ParameterizedType p = (ParameterizedType)type;
            return (Class)p.getActualTypeArguments()[index];
        }
        return Object.class;
    }
}

