/*
 * Copyright (c)  2019. houbinbin Inc.
 * heaven All rights reserved.
 */

package com.github.houbb.heaven.constant;

/**
 * 字符常量
 *
 * @author bbhou
 * @version 0.1.27
 */
public final class CharConst {

    private CharConst(){}

    /**
     * 逗号
     */
    public static final char COMMA = ',';

    /**
     * 冒号
     */
    public static final char COLON = ':';

    /**
     * char 小数点
     */
    public static final char DOT = '.';

    /**
     * char 双引号
     * @since 0.1.25
     */
    public static final char DOUBLE_QUOTES = '"';

    /**
     * char 反斜杠
     * @since 0.1.25
     */
    public static final char BACK_SLASH = '\\';

    /**
     * char 空格
     * @since 0.1.25
     */
    public static final char BLANK = ' ';

    /**
     * 星星
     * @since 0.1.67
     */
    public static final char STAR = '*';
}
