/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MapUtil {
    private MapUtil() {
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || 0 == map.size();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> Map<K, V> toMap(Collection<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(values.size());
        for (V value : values) {
            K key = keyFunction.handle(value);
            map.put(key, value);
        }
        return map;
    }

    public static <V> Map<Integer, V> toIndexMap(Collection<V> values) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, V> map = new HashMap<Integer, V>(values.size());
        for (V v : values) {
            map.put(map.size(), v);
        }
        return map;
    }

    public static String getMapValue(Map<String, String> map, String key) {
        if (MapUtil.isEmpty(map)) {
            return key;
        }
        String value = map.get(key);
        if (StringUtil.isEmpty(value)) {
            return key;
        }
        return value;
    }
}

