/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassLoaderUtil {
    public static Class<?> loadClass(String classFilePath, String classFullName) {
        try {
            File file = new File(classFilePath);
            URL url = file.toURI().toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            return classLoader.loadClass(classFullName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to convert file to URL", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + classFullName, e);
        }
    }

    public static Class<?> loadClassFromFile(String classFilePath) {
        try {
            if (classFilePath == null || classFilePath.isEmpty()) {
                throw new IllegalArgumentException("Class file path must not be null or empty.");
            }
            File file = new File(classFilePath);
            URL url = file.toURI().toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
            try {
                String className = file.getName().substring(0, file.getName().length() - 6);
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + classFilePath, e);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

