/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.report.impl;

import com.github.houbb.heaven.util.lang.ConsoleUtil;
import com.github.houbb.junitperf.constant.enums.StatusEnum;
import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationRequire;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationResult;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2_0_0")
public class ConsoleReporter
implements Reporter {
    @Override
    public void report(Class testClass, Collection<EvaluationContext> evaluationContextSet) {
        for (EvaluationContext context : evaluationContextSet) {
            StatisticsCalculator statistics = context.getStatisticsCalculator();
            EvaluationConfig evaluationConfig = context.getEvaluationConfig();
            EvaluationRequire evaluationRequire = context.getEvaluationRequire();
            EvaluationResult evaluationResult = context.getEvaluationResult();
            String throughputStatus = this.getStatus(evaluationResult.isTimesPerSecondAchieved());
            this.infoLog(context, "--------------------------------------------------------", new Object[0]);
            this.infoLog(context, "Started at:  {}", context.getStartTime());
            this.infoLog(context, "Invocations:  {}", statistics.getEvaluationCount());
            this.infoLog(context, "Success:  {}", statistics.getEvaluationCount() - statistics.getErrorCount());
            this.infoLog(context, "Errors:  {}", statistics.getErrorCount());
            this.infoLog(context, "Thread Count:  {}", evaluationConfig.getConfigThreads());
            this.infoLog(context, "Warm up:  {}ms", evaluationConfig.getConfigWarmUp());
            this.infoLog(context, "Execution time:  {}ms", evaluationConfig.getConfigDuration());
            this.infoLog(context, "Throughput:  {}/s (Required: {}/s) - {}", evaluationResult.getThroughputQps(), evaluationRequire.getRequireTimesPerSecond(), throughputStatus);
            this.infoLog(context, "Memory cost:  {}byte", statistics.getMemory());
            this.infoLog(context, "Min latency:  {}ms (Required: {}ms) - {}", Float.valueOf(statistics.getMinLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireMin()), this.getStatus(evaluationResult.isMinAchieved()));
            this.infoLog(context, "Max latency:  {}ms (Required: {}ms) - {}", Float.valueOf(statistics.getMaxLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireMax()), this.getStatus(evaluationResult.isMaxAchieved()));
            this.infoLog(context, "Avg latency:  {}ms (Required: {}ms) - {}", Float.valueOf(statistics.getMeanLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireAverage()), this.getStatus(evaluationResult.isAverageAchieved()));
            for (Map.Entry<Integer, Float> entry : evaluationRequire.getRequirePercentilesMap().entrySet()) {
                Integer percentile = entry.getKey();
                Float threshold = entry.getValue();
                boolean result = evaluationResult.getIsPercentilesAchievedMap().get(percentile);
                String percentileStatus = this.getStatus(result);
                this.infoLog(context, "Percentile: {}%%   {}ms (Required: {}ms) - {}", percentile, Float.valueOf(statistics.getLatencyPercentile(percentile, TimeUnit.MILLISECONDS)), threshold, percentileStatus);
            }
            this.infoLog(context, "--------------------------------------------------------", new Object[0]);
        }
    }

    private void infoLog(EvaluationContext context, String format, Object ... args) {
        String className = context.getTestInstance().getClass().getName();
        String methodName = context.getMethodName();
        ConsoleUtil.info((String)className, (String)methodName, (String)format, (Object[])args);
    }

    private String getStatus(boolean isSuccess) {
        if (isSuccess) {
            return StatusEnum.PASSED.getStatus();
        }
        return StatusEnum.FAILED.getStatus();
    }
}

