/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.statistics.impl;

import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2_0_0")
public class DefaultStatisticsCalculator
implements StatisticsCalculator {
    private static final long serialVersionUID = 3715867392352544936L;
    private final DescriptiveStatistics latencyStatistics;
    private final AtomicLong evaluationCount = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();
    private volatile long memoryKb;

    public DefaultStatisticsCalculator() {
        this((DescriptiveStatistics)new SynchronizedDescriptiveStatistics());
    }

    private DefaultStatisticsCalculator(DescriptiveStatistics latencyStatistics) {
        this.latencyStatistics = latencyStatistics;
    }

    @Override
    public void addLatencyMeasurement(long executionTimeNs) {
        this.latencyStatistics.addValue((double)executionTimeNs);
    }

    @Override
    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    @Override
    public float getErrorPercentage() {
        return (float)this.getErrorCount() / (float)this.getEvaluationCount() * 100.0f;
    }

    @Override
    public void incrementEvaluationCount() {
        this.evaluationCount.incrementAndGet();
    }

    @Override
    public long getEvaluationCount() {
        return this.evaluationCount.get();
    }

    @Override
    public float getLatencyPercentile(int percentile, TimeUnit unit) {
        return (float)this.latencyStatistics.getPercentile((double)percentile) / (float)unit.toNanos(1L);
    }

    @Override
    public float getMaxLatency(TimeUnit unit) {
        return (float)this.latencyStatistics.getMax() / (float)unit.toNanos(1L);
    }

    @Override
    public float getMinLatency(TimeUnit unit) {
        return (float)this.latencyStatistics.getMin() / (float)unit.toNanos(1L);
    }

    @Override
    public float getMeanLatency(TimeUnit unit) {
        return (float)this.latencyStatistics.getMean() / (float)unit.toNanos(1L);
    }

    @Override
    public void setMemory(long memoryKb) {
        this.memoryKb = memoryKb;
    }

    @Override
    public long getMemory() {
        return this.memoryKb;
    }
}

