/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.builder;

import com.github.houbb.heaven.support.builder.IBuilder;
import com.github.houbb.junitperf.core.annotation.JunitPerfConfig;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.google.common.base.Preconditions;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class EvaluationConfigBuilder
implements IBuilder<EvaluationConfig> {
    private final JunitPerfConfig junitPerfConfig;

    public EvaluationConfigBuilder(JunitPerfConfig junitPerfConfig) {
        this.junitPerfConfig = junitPerfConfig;
    }

    public EvaluationConfig build() {
        this.validateJunitPerfConfig(this.junitPerfConfig);
        EvaluationConfig evaluationConfig = new EvaluationConfig();
        evaluationConfig.setConfigThreads(this.junitPerfConfig.threads());
        evaluationConfig.setConfigWarmUp(this.junitPerfConfig.warmUp());
        evaluationConfig.setConfigDuration(this.junitPerfConfig.duration());
        return evaluationConfig;
    }

    private void validateJunitPerfConfig(JunitPerfConfig junitPerfConfig) {
        Preconditions.checkNotNull((Object)junitPerfConfig, (Object)"JunitPerfConfig must not be null!");
        int threads = junitPerfConfig.threads();
        long warmUp = junitPerfConfig.warmUp();
        long duration = junitPerfConfig.duration();
        Preconditions.checkState((duration > 0L ? 1 : 0) != 0, (Object)"duration must be > 0ms.");
        Preconditions.checkState((warmUp >= 0L ? 1 : 0) != 0, (Object)"warmUp must be >= 0ms.");
        Preconditions.checkState((warmUp < duration ? 1 : 0) != 0, (Object)"warmUp must be < duration.");
        Preconditions.checkState((threads > 0 ? 1 : 0) != 0, (Object)"threads must be > 0.");
    }
}

