/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.builder;

import com.github.houbb.heaven.support.builder.IBuilder;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.junitperf.core.annotation.JunitPerfRequire;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationRequire;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class EvaluationRequireBuilder
implements IBuilder<EvaluationRequire> {
    private final JunitPerfRequire junitPerfRequire;

    public EvaluationRequireBuilder(JunitPerfRequire junitPerfRequire) {
        this.junitPerfRequire = junitPerfRequire;
    }

    public EvaluationRequire build() {
        EvaluationRequire evaluationRequire = new EvaluationRequire();
        if (ObjectUtil.isNotNull((Object)this.junitPerfRequire)) {
            this.validateJunitPerfRequire(this.junitPerfRequire);
            evaluationRequire.setRequireMin(this.junitPerfRequire.min());
            evaluationRequire.setRequireMax(this.junitPerfRequire.max());
            evaluationRequire.setRequireAverage(this.junitPerfRequire.average());
            evaluationRequire.setRequireTimesPerSecond(this.junitPerfRequire.timesPerSecond());
            evaluationRequire.setRequirePercentilesMap(this.parseRequirePercentilesMap(this.junitPerfRequire.percentiles()));
        } else {
            evaluationRequire.setRequireMin(-1.0f);
            evaluationRequire.setRequireMax(-1.0f);
            evaluationRequire.setRequireAverage(-1.0f);
            evaluationRequire.setRequireTimesPerSecond(-1);
            evaluationRequire.setRequirePercentilesMap(Maps.newHashMap());
        }
        return evaluationRequire;
    }

    private void validateJunitPerfRequire(JunitPerfRequire junitPerfRequire) {
        Preconditions.checkState((junitPerfRequire.timesPerSecond() >= 0 ? 1 : 0) != 0, (Object)"timesPerSecond must be >= 0");
    }

    private Map<Integer, Float> parseRequirePercentilesMap(String[] percentiles) {
        HashMap percentilesMap = Maps.newHashMap();
        if (ArrayUtil.isNotEmpty((Object[])percentiles)) {
            try {
                for (String percent : percentiles) {
                    String[] strings = percent.split(":");
                    Integer left = Ints.tryParse((String)strings[0]);
                    Float right = Floats.tryParse((String)strings[1]);
                    percentilesMap.put(left, right);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Percentiles format is error! please like this: 80:50000.");
            }
        }
        return percentilesMap;
    }
}

