/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.statements;

import com.github.houbb.heaven.util.lang.ThreadUtil;
import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.support.exception.JunitPerfRuntimeException;
import com.github.houbb.junitperf.support.i18n.I18N;
import com.github.houbb.junitperf.support.task.PerformanceEvaluationTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2_0_0")
public class PerformanceEvaluationStatement {
    private static final String THREAD_NAME_PATTERN = "performance-evaluation-thread-%d";
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("performance-evaluation-thread-%d").build();
    private final EvaluationContext evaluationContext;
    private final StatisticsCalculator statisticsCalculator;
    private final Set<Reporter> reporterSet;
    private final Collection<EvaluationContext> evaluationContextList;
    private final Class testClass;

    public PerformanceEvaluationStatement(EvaluationContext evaluationContext, StatisticsCalculator statisticsCalculator, Set<Reporter> reporterSet, Collection<EvaluationContext> evaluationContextList, Class testClass) {
        this.evaluationContext = evaluationContext;
        this.statisticsCalculator = statisticsCalculator;
        this.reporterSet = reporterSet;
        this.evaluationContextList = evaluationContextList;
        this.testClass = testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        LinkedList<PerformanceEvaluationTask> taskList = new LinkedList<PerformanceEvaluationTask>();
        try {
            EvaluationConfig evaluationConfig = this.evaluationContext.getEvaluationConfig();
            for (int i = 0; i < evaluationConfig.getConfigThreads(); ++i) {
                PerformanceEvaluationTask task = new PerformanceEvaluationTask(evaluationConfig.getConfigWarmUp(), this.statisticsCalculator, this.evaluationContext.getTestInstance(), this.evaluationContext.getTestMethod());
                Thread t = FACTORY.newThread(task);
                taskList.add(task);
                t.start();
            }
            Thread.sleep(evaluationConfig.getConfigDuration());
        }
        finally {
            for (PerformanceEvaluationTask task : taskList) {
                task.setContinue(false);
            }
        }
        this.evaluationContext.setStatisticsCalculator(this.statisticsCalculator);
        this.evaluationContext.runValidation();
        this.generateReporter();
    }

    private synchronized void generateReporter() {
        int bestThreadNum;
        if (this.reporterSet.isEmpty()) {
            String string = I18N.get("reportIsEmpty");
        }
        if ((bestThreadNum = ThreadUtil.bestThreadNum((int)this.reporterSet.size())) <= 1) {
            Reporter reporter = this.reporterSet.iterator().next();
            reporter.report(this.testClass, this.evaluationContextList);
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(bestThreadNum);
            ArrayList<Future<Void>> futureTasks = new ArrayList<Future<Void>>();
            for (Reporter reporter : this.reporterSet) {
                Callable<Void> tocGenCallable = () -> {
                    reporter.report(this.testClass, this.evaluationContextList);
                    return null;
                };
                Future<Void> reporterFuture = executorService.submit(tocGenCallable);
                futureTasks.add(reporterFuture);
            }
            executorService.shutdown();
            try {
                for (Future future : futureTasks) {
                    Void void_ = (Void)future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
                throw new JunitPerfRuntimeException(e);
            }
        }
    }
}

