/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.core.impl;

import com.github.houbb.markdown.toc.core.MarkdownToc;
import com.github.houbb.markdown.toc.exception.MarkdownTocRuntimeException;
import com.github.houbb.markdown.toc.support.I18N;
import com.github.houbb.markdown.toc.util.CollectionUtil;
import com.github.houbb.markdown.toc.util.FileUtil;
import com.github.houbb.markdown.toc.util.StringUtil;
import com.github.houbb.markdown.toc.util.ThreadLocalUtil;
import com.github.houbb.markdown.toc.util.ThreadUtil;
import com.github.houbb.markdown.toc.vo.TocGen;
import com.github.houbb.markdown.toc.vo.config.TocConfig;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.0.0")
public class AtxMarkdownToc
implements MarkdownToc {
    private Charset charset = Charset.forName("UTF-8");
    private boolean subTree = true;
    private boolean write = true;
    private boolean order = false;

    @Override
    public TocGen genTocFile(String filePath) {
        this.checkPath(filePath);
        TocConfig config = this.buildConfig();
        return ThreadLocalUtil.genTocFile(filePath, config);
    }

    private TocConfig buildConfig() {
        TocConfig tocConfig = new TocConfig();
        tocConfig.setCharset(this.charset);
        tocConfig.setSubTree(this.subTree);
        tocConfig.setWrite(this.write);
        tocConfig.setOrder(this.order);
        return tocConfig;
    }

    @Override
    public List<TocGen> genTocDir(String dirPath) {
        this.checkPath(dirPath);
        CopyOnWriteArrayList<TocGen> tocGens = new CopyOnWriteArrayList<TocGen>();
        final TocConfig config = this.buildConfig();
        Path path = Paths.get(dirPath, new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            String msg = String.format(I18N.get("pathIsNotDirectory"), dirPath);
            throw new MarkdownTocRuntimeException(msg);
        }
        List<Path> paths = FileUtil.getMdFilePathList(path, this.subTree);
        if (CollectionUtil.isEmpty(paths)) {
            return Collections.emptyList();
        }
        int bestThreadNum = ThreadUtil.bestThreadNum(paths.size());
        if (bestThreadNum <= 1) {
            Path firstPath = paths.get(0);
            TocGen tocGen = this.genTocFile(firstPath.toString());
            return Collections.singletonList(tocGen);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(bestThreadNum);
        ArrayList<Future<TocGen>> futureTasks = new ArrayList<Future<TocGen>>();
        for (final Path path2 : paths) {
            Callable<TocGen> tocGenCallable = new Callable<TocGen>(){

                @Override
                public TocGen call() {
                    return ThreadLocalUtil.genTocFile(path2.toString(), config);
                }
            };
            Future<TocGen> tocGenFuture = executorService.submit(tocGenCallable);
            futureTasks.add(tocGenFuture);
        }
        executorService.shutdown();
        ThreadLocalUtil.clear();
        try {
            for (Future future : futureTasks) {
                TocGen tocGen = (TocGen)future.get();
                tocGens.add(tocGen);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MarkdownTocRuntimeException(e);
        }
        return tocGens;
    }

    public static AtxMarkdownToc newInstance() {
        return new AtxMarkdownToc();
    }

    public AtxMarkdownToc charset(String charset) {
        this.charset = Charset.forName(charset);
        return this;
    }

    public AtxMarkdownToc subTree(boolean subTree) {
        this.subTree = subTree;
        return this;
    }

    public AtxMarkdownToc write(boolean write) {
        this.write = write;
        return this;
    }

    public AtxMarkdownToc order(boolean order) {
        this.order = order;
        return this;
    }

    private void checkPath(String path) {
        if (StringUtil.isEmpty(path)) {
            throw new MarkdownTocRuntimeException(I18N.get("pathIsNotAllowEmpty"));
        }
    }
}

