/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.support;

import com.github.houbb.markdown.toc.util.SpecialCharUtil;
import com.github.houbb.markdown.toc.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.0")
public class IncreaseMap {
    private Map<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();

    public String buildActualName(String originalName) {
        String actualName;
        String tocHref = IncreaseMap.getTocHref(originalName);
        AtomicInteger value = this.map.get(tocHref);
        if (value != null) {
            int count = value.incrementAndGet();
            actualName = "#" + tocHref + "-" + count;
        } else {
            AtomicInteger one = new AtomicInteger(0);
            this.map.put(tocHref, one);
            actualName = "#" + tocHref;
        }
        return actualName;
    }

    private static String getTocHref(String tocTitle) {
        if (StringUtil.isEmpty(tocTitle)) {
            return tocTitle;
        }
        String result = tocTitle.toLowerCase();
        result = result.replace(' ', '-');
        for (String specialChar : SpecialCharUtil.getSpecialCharSet()) {
            result = result.replace(specialChar, "");
        }
        return result;
    }
}

