/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.support;

import com.github.houbb.markdown.toc.util.FileUtil;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.0")
public class MarkdownFileWalker
extends SimpleFileVisitor<Path> {
    private List<Path> pathList = new ArrayList<Path>();

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (FileUtil.isMdFile(file.toString())) {
            this.pathList.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    public List<Path> getPathList() {
        return Collections.unmodifiableList(this.pathList);
    }
}

