/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.support.md.impl;

import com.github.houbb.markdown.toc.constant.TocConstant;
import com.github.houbb.markdown.toc.support.IncreaseMap;
import com.github.houbb.markdown.toc.support.md.MarkdownContentToc;
import com.github.houbb.markdown.toc.util.CollectionUtil;
import com.github.houbb.markdown.toc.vo.TocVo;
import com.github.houbb.markdown.toc.vo.config.TocConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.4")
public class AtxMarkdownContentToc
implements MarkdownContentToc {
    private final TocConfig config;
    private List<String> tocStrList = new LinkedList<String>();
    private List<TocVo> tocVoList = new LinkedList<TocVo>();
    private List<String> resultList = new LinkedList<String>();
    private TocVo previous;

    public AtxMarkdownContentToc(TocConfig config) {
        this.config = config;
    }

    @Override
    public List<String> getPureTocList(List<String> contentLines) {
        if (CollectionUtil.isEmpty(contentLines)) {
            return Collections.emptyList();
        }
        return this.buildTocList(contentLines);
    }

    @Override
    public List<String> getPureContentList(List<String> contentLines) {
        LinkedList<String> resultList = new LinkedList<String>(contentLines);
        String firstLine = (String)resultList.get(0);
        if (firstLine.startsWith("# Table of Contents")) {
            String contentTrim;
            Iterator<String> stringIterator = resultList.iterator();
            this.nextAndRemove(stringIterator, 2);
            while (stringIterator.hasNext() && (contentTrim = stringIterator.next().trim()).startsWith("*")) {
                stringIterator.remove();
            }
            if (stringIterator.hasNext()) {
                stringIterator.remove();
            }
            this.nextAndRemove(stringIterator, 1);
        }
        return resultList;
    }

    private List<String> buildTocList(List<String> contentList) {
        if (CollectionUtil.isEmpty(contentList)) {
            return Collections.emptyList();
        }
        this.resultList.add("# Table of Contents" + TocConstant.RETURN_LINE);
        for (String string : contentList) {
            String trim = string.trim();
            if (!trim.startsWith("#")) continue;
            this.tocStrList.add(trim);
        }
        IncreaseMap increaseMap = new IncreaseMap();
        TocVo root = TocVo.rootToc(increaseMap);
        root.setParent(null);
        this.tocVoList.add(root);
        this.previous = root;
        for (String string : this.tocStrList) {
            this.addNewToc(string, increaseMap);
        }
        this.showToc(root.getChildren());
        this.resultList.add(TocConstant.RETURN_LINE);
        return this.resultList;
    }

    private void showToc(List<TocVo> tocVoList) {
        if (this.tocStrList.isEmpty() || CollectionUtil.isEmpty(tocVoList)) {
            return;
        }
        for (TocVo tocVo : tocVoList) {
            this.fillTocVo(tocVo);
            String intent = tocVo.getIndent();
            String tocVoContent = intent + String.format("* %s[%s](%s)", tocVo.getOrderDesc(), tocVo.getTocTitle(), tocVo.getTocHref());
            this.resultList.add(tocVoContent);
            this.showToc(tocVo.getChildren());
        }
    }

    private void fillTocVo(TocVo tocVo) {
        int level = tocVo.getLevel();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < level - 1; ++i) {
            prefixBuilder.append("  ");
        }
        tocVo.setIndent(prefixBuilder.toString());
        if (this.config.isOrder()) {
            String orderDesc = this.buildOrderDesc(tocVo);
            tocVo.setOrderDesc(orderDesc);
        } else {
            tocVo.setOrderDesc("");
        }
    }

    private String buildOrderDesc(TocVo tocVo) {
        ArrayList<Integer> orderList = new ArrayList<Integer>();
        orderList.add(tocVo.getOrder());
        TocVo current = tocVo;
        while (current.getLevel() >= 1) {
            if ((current = current.getParent()).getLevel() < 1) continue;
            orderList.add(current.getOrder());
        }
        Collections.reverse(orderList);
        return CollectionUtil.join(orderList, ".") + " ";
    }

    private void nextAndRemove(Iterator<String> stringIterator, int times) {
        for (int i = 0; i < times; ++i) {
            if (!stringIterator.hasNext()) continue;
            String content = stringIterator.next();
            stringIterator.remove();
        }
    }

    private void addNewToc(String tocTrimStr, IncreaseMap increaseMap) {
        TocVo current = new TocVo(tocTrimStr, increaseMap);
        if (current.getLevel() == 1) {
            TocVo root = this.tocVoList.get(0);
            current.setParent(root);
            root.getChildren().add(current);
        } else if (current.getLevel() <= this.previous.getLevel()) {
            TocVo previousParent = this.previous.getParent();
            current.setParent(previousParent);
            previousParent.getChildren().add(current);
        } else if (current.getLevel() > this.previous.getLevel()) {
            current.setParent(this.previous);
            this.previous.getChildren().add(current);
        }
        TocVo parentToc = current.getParent();
        List<TocVo> childrenList = parentToc.getChildren();
        current.setOrder(childrenList.size());
        this.previous = current;
    }
}

